/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.serenitybdd.core.SerenitySystemProperties;
import net.serenitybdd.core.time.Stopwatch;
import net.serenitybdd.reports.model.DurationDistribution;
import net.serenitybdd.reports.model.FrequentFailures;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.CopyFiles;
import net.thucydides.core.reports.FormatConfiguration;
import net.thucydides.core.reports.OutcomeFormat;
import net.thucydides.core.reports.TestOutcomeLoader;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.UserStoryTestReporter;
import net.thucydides.core.reports.html.AggregateReportingTask;
import net.thucydides.core.reports.html.ErrorTypeReportingTask;
import net.thucydides.core.reports.html.FreemarkerContext;
import net.thucydides.core.reports.html.HtmlReporter;
import net.thucydides.core.reports.html.HtmlTestOutcomeReportingTask;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.Reporter;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.core.reports.html.RequirementsReports;
import net.thucydides.core.reports.html.ResultReports;
import net.thucydides.core.reports.html.TagReportingTask;
import net.thucydides.core.reports.html.TextSummaryReportTask;
import net.thucydides.core.requirements.DefaultRequirements;
import net.thucydides.core.requirements.Requirements;
import net.thucydides.core.requirements.model.RequirementsConfiguration;
import net.thucydides.core.requirements.reports.RequirementsOutcomes;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlAggregateStoryReporter
extends HtmlReporter
implements UserStoryTestReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlAggregateStoryReporter.class);
    private String projectName;
    private String projectDirectory;
    private String relativeLink;
    private String tags;
    private final IssueTracking issueTracking;
    private final RequirementsConfiguration requirementsConfiguration;
    private final ReportNameProvider reportNameProvider;
    private final Requirements requirements;
    private FormatConfiguration formatConfiguration;
    private boolean generateTestOutcomeReports = false;
    public static final CopyOption[] COPY_OPTIONS = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES};

    public HtmlAggregateStoryReporter(String projectName) {
        this(projectName, "");
    }

    public HtmlAggregateStoryReporter(String projectName, Requirements requirements) {
        this(projectName, "", (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class), (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get(), requirements);
    }

    public HtmlAggregateStoryReporter(String projectName, String relativeLink) {
        this(projectName, relativeLink, (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class), (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    public HtmlAggregateStoryReporter(String projectName, IssueTracking issueTracking) {
        this(projectName, "", issueTracking, (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get(), (Requirements)new DefaultRequirements());
    }

    public HtmlAggregateStoryReporter(String projectName, String relativeLink, IssueTracking issueTracking, EnvironmentVariables environmentVariables) {
        this(projectName, relativeLink, issueTracking, environmentVariables, (Requirements)new DefaultRequirements());
    }

    public HtmlAggregateStoryReporter(String projectName, String relativeLink, IssueTracking issueTracking, EnvironmentVariables environmentVariables, Requirements requirements) {
        super(environmentVariables);
        this.projectName = projectName;
        this.relativeLink = relativeLink;
        this.issueTracking = issueTracking;
        this.requirementsConfiguration = new RequirementsConfiguration(this.getEnvironmentVariables());
        this.formatConfiguration = new FormatConfiguration(environmentVariables);
        this.reportNameProvider = new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, requirements.getRequirementsService());
        this.requirements = requirements;
    }

    public OutcomeFormat getFormat() {
        return this.formatConfiguration.getPreferredFormat();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public TestOutcomes generateReportsForTestResultsFrom(File sourceDirectory) throws IOException {
        Stopwatch stopwatch = Stopwatch.started();
        this.copyScreenshotsFrom(sourceDirectory);
        LOGGER.trace("Copied screenshots after {}", (Object)stopwatch.lapTimeFormatted());
        TestOutcomes allTestOutcomes = this.loadTestOutcomesFrom(sourceDirectory);
        if (!StringUtils.isEmpty((CharSequence)this.tags)) {
            allTestOutcomes = allTestOutcomes.withTags(this.getTags());
        }
        LOGGER.trace("Loaded test outcomes after {}", (Object)stopwatch.lapTimeFormatted());
        this.generateReportsForTestResultsIn(allTestOutcomes);
        LOGGER.trace("Generated reports after {}", (Object)stopwatch.lapTimeFormatted());
        return allTestOutcomes;
    }

    private void copyScreenshotsFrom(File sourceDirectory) {
        CopyFiles.from(sourceDirectory).to(this.getOutputDirectory());
    }

    public void generateReportsForTestResultsIn(TestOutcomes testOutcomes) throws IOException {
        Stopwatch stopwatch = Stopwatch.started();
        try (Reporter reporter = new Reporter(this.environmentVariables);){
            LOGGER.debug("Generating test results for {} tests", (Object)testOutcomes.getTestCount());
            DurationDistribution durationDistribution = new DurationDistribution(this.environmentVariables, testOutcomes);
            this.enhanceWithDurationTags(durationDistribution, testOutcomes);
            FreemarkerContext context = new FreemarkerContext(this.environmentVariables, this.requirements.getRequirementsService(), this.issueTracking, this.relativeLink);
            RequirementsOutcomes requirementsOutcomes = this.requirements.getRequirementsOutcomeFactory().buildRequirementsOutcomesFrom(testOutcomes);
            LOGGER.debug("{} requirements loaded after {}", (Object)requirementsOutcomes.getFlattenedRequirementCount(), (Object)stopwatch.lapTimeFormatted());
            LOGGER.debug("{} related requirements found after {}", (Object)requirementsOutcomes.getFlattenedRequirementCount(), (Object)stopwatch.lapTimeFormatted());
            List<String> knownRequirementReportNames = this.requirementReportNamesFrom(requirementsOutcomes, this.reportNameProvider);
            if (this.generateTestOutcomeReports) {
                reporter.generateReportsFor(HtmlTestOutcomeReportingTask.testOutcomeReportsFor(testOutcomes).using(this.environmentVariables, this.requirements.getRequirementsService(), this.getOutputDirectory(), this.issueTracking));
            }
            List requirementTypes = this.requirementsConfiguration.getRequirementTypes();
            LOGGER.info("GENERATING SUMMARY REPORTS...");
            reporter.generateReportsFor(Stream.of(Stream.of(new TextSummaryReportTask(context, this.environmentVariables, this.getOutputDirectory(), testOutcomes), new CopyResourcesTask(), new CopyTestResultsTask(), new AggregateReportingTask(context, this.environmentVariables, this.requirements.getRequirementsService(), this.getOutputDirectory(), testOutcomes)), TagReportingTask.tagReportsFor(testOutcomes).using(context, this.environmentVariables, this.getOutputDirectory(), this.reportNameProvider, testOutcomes.getTags(), requirementTypes, knownRequirementReportNames), this.tagReports(durationDistribution, testOutcomes, context, requirementTypes, knownRequirementReportNames)).flatMap(stream -> stream));
            LOGGER.info("GENERATING REQUIREMENTS REPORTS...");
            reporter.generateReportsFor(RequirementsReports.requirementsReportsFor(context, this.environmentVariables, this.getOutputDirectory(), this.reportNameProvider, this.requirements.getRequirementsOutcomeFactory(), this.requirements.getRequirementsService(), this.relativeLink, testOutcomes, requirementsOutcomes));
            LOGGER.info("GENERATING RESULT REPORTS...");
            reporter.generateReportsFor(ResultReports.resultReportsFor(testOutcomes, context, this.environmentVariables, this.getOutputDirectory(), this.reportNameProvider));
            LOGGER.info("GENERATING ERROR REPORTS...");
            List failures = FrequentFailures.from((TestOutcomes)testOutcomes).withMaxOf(ThucydidesSystemProperty.REPORT_SCOREBOARD_SIZE.integerFrom(this.environmentVariables, 5));
            reporter.generateReportsFor(failures.stream().map(failure -> new ErrorTypeReportingTask(context, this.environmentVariables, this.requirements.getRequirementsService(), this.getOutputDirectory(), this.reportNameProvider, testOutcomes.withErrorType(failure.getType()).withLabel("Tests with error: " + failure.getName()), failure.getType())));
        }
        LOGGER.info("Test results for {} tests generated in {} in directory: {}", new Object[]{testOutcomes.getTestCount(), stopwatch.executionTimeFormatted(), this.getOutputDirectory().toURI()});
    }

    private Stream<ReportingTask> tagReports(DurationDistribution durationDistribution, TestOutcomes testOutcomes, FreemarkerContext context, List<String> requirementTypes, List<String> knownRequirementReportNames) {
        return TagReportingTask.tagReportsFor(testOutcomes).using(context, this.environmentVariables, this.getOutputDirectory(), this.reportNameProvider, durationDistribution.getDurationTagsSet(), requirementTypes, knownRequirementReportNames);
    }

    private void enhanceWithDurationTags(DurationDistribution distribution, TestOutcomes testOutcomes) {
        for (TestOutcome testOutcome : testOutcomes.getOutcomes()) {
            this.enhanceWithDuration(testOutcome, distribution);
        }
    }

    private void enhanceWithDuration(TestOutcome testOutcome, DurationDistribution durationDistribution) {
        durationDistribution.findMatchingBucketsForTestOutcome(testOutcome).forEach(bucket -> testOutcome.addTag(TestTag.withName((String)bucket.getDuration()).andType("Duration")));
    }

    private List<String> requirementReportNamesFrom(RequirementsOutcomes requirementsOutcomes, ReportNameProvider reportNameProvider) {
        return requirementsOutcomes.getFlattenedRequirementOutcomes().stream().map(req -> reportNameProvider.forRequirement(req.getRequirement())).collect(Collectors.toList());
    }

    private TestOutcomes loadTestOutcomesFrom(File sourceDirectory) throws IOException {
        return TestOutcomeLoader.loadTestOutcomes().inFormat(this.getFormat()).from(sourceDirectory).withRequirementsTags();
    }

    protected SerenitySystemProperties getSystemProperties() {
        return SerenitySystemProperties.getProperties();
    }

    public void setIssueTrackerUrl(String issueTrackerUrl) {
        if (issueTrackerUrl != null) {
            this.setEnvironmentProperty(ThucydidesSystemProperty.SERENITY_ISSUE_TRACKER_URL, issueTrackerUrl);
        }
    }

    private void setEnvironmentProperty(ThucydidesSystemProperty property, String value) {
        this.getSystemProperties().setValue(property, value);
        this.environmentVariables.setProperty(property.getPropertyName(), value);
    }

    public void setJiraUrl(String jiraUrl) {
        if (jiraUrl != null) {
            this.setEnvironmentProperty(ThucydidesSystemProperty.JIRA_URL, jiraUrl);
        }
    }

    public void setJiraProject(String jiraProject) {
        if (jiraProject != null) {
            this.setEnvironmentProperty(ThucydidesSystemProperty.JIRA_PROJECT, jiraProject);
        }
    }

    public void setJiraUsername(String jiraUsername) {
        if (jiraUsername != null) {
            this.setEnvironmentProperty(ThucydidesSystemProperty.JIRA_USERNAME, jiraUsername);
        }
    }

    public void setTags(String tags) {
        this.tags = tags != null ? tags.replaceAll("\\s+((or)|(OR)|(and)|(AND))\\s+", ",") : null;
    }

    public void setJiraPassword(String jiraPassword) {
        if (jiraPassword != null) {
            this.setEnvironmentProperty(ThucydidesSystemProperty.JIRA_PASSWORD, jiraPassword);
        }
    }

    public List<String> getRequirementTypes() {
        List types = this.requirements.getTypes();
        if (types.isEmpty()) {
            LOGGER.warn("No requirement types found in the test outcome requirements: using default requirements");
            return this.requirementsConfiguration.getRequirementTypes();
        }
        return types;
    }

    public List<TestTag> getTags() {
        ArrayList<TestTag> tagList = new ArrayList<TestTag>();
        if (StringUtils.isEmpty((CharSequence)this.tags)) {
            return tagList;
        }
        for (String tagValue : StringUtils.split((String)this.tags, (String)",")) {
            tagList.add(TestTag.withValue((String)tagValue.trim()));
        }
        return tagList;
    }

    public void setGenerateTestOutcomeReports() {
        this.generateTestOutcomeReports = true;
    }

    public void setProjectDirectory(String projectDirectory) {
        this.projectDirectory = projectDirectory;
        this.environmentVariables.setProperty("serenity.project.directory", projectDirectory);
        System.setProperty("serenity.project.directory", projectDirectory);
    }

    public void setTestRoot(String testRoot) {
        if (testRoot != null) {
            this.setEnvironmentProperty(ThucydidesSystemProperty.SERENITY_TEST_ROOT, testRoot);
            this.requirements.getRequirementsService().resetRequirements();
        }
    }

    private class CopyTestResultsTask
    implements ReportingTask {
        private CopyTestResultsTask() {
        }

        @Override
        public void generateReports() throws IOException {
            HtmlAggregateStoryReporter.this.copyTestResultsToOutputDirectory();
        }

        @Override
        public String reportName() {
            return "CopyTestResultsTask";
        }
    }

    private class CopyResourcesTask
    implements ReportingTask {
        private CopyResourcesTask() {
        }

        @Override
        public void generateReports() throws IOException {
            HtmlAggregateStoryReporter.this.copyResourcesToOutputDirectory();
        }

        @Override
        public String reportName() {
            return "CopyResourcesTask";
        }
    }
}

