/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.base.Objects;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.serenitybdd.model.environment.EnvironmentSpecificConfiguration;
import net.serenitybdd.model.time.Stopwatch;
import net.thucydides.core.reports.ScenarioOutcomeGroup;
import net.thucydides.core.reports.html.BaseReportingTask;
import net.thucydides.core.reports.html.Breadcrumbs;
import net.thucydides.core.reports.html.DuplicateRequirementNames;
import net.thucydides.core.reports.html.EvidenceData;
import net.thucydides.core.reports.html.FreemarkerContext;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.core.reports.html.RequirementCounts;
import net.thucydides.core.reports.html.ResultCountCache;
import net.thucydides.core.reports.html.TestOutcomeTimestamp;
import net.thucydides.core.reports.html.accessibility.ChartColorScheme;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.domain.ReportType;
import net.thucydides.model.domain.Rule;
import net.thucydides.model.domain.TestTag;
import net.thucydides.model.reports.ReportOptions;
import net.thucydides.model.reports.TestOutcomes;
import net.thucydides.model.reports.html.ReportNameProvider;
import net.thucydides.model.reports.html.RequirementsFilter;
import net.thucydides.model.reports.html.ScenarioResultCounts;
import net.thucydides.model.reports.html.TagFilter;
import net.thucydides.model.requirements.JSONRequirementsTree;
import net.thucydides.model.requirements.RequirementsService;
import net.thucydides.model.requirements.model.Requirement;
import net.thucydides.model.requirements.reports.RequirementOutcome;
import net.thucydides.model.requirements.reports.RequirementsOutcomes;
import net.thucydides.model.requirements.reports.ScenarioOutcome;
import net.thucydides.model.requirements.reports.ScenarioOutcomes;
import net.thucydides.model.tags.BreadcrumbTagFilter;
import net.thucydides.model.tags.OutcomeTagFilter;
import net.thucydides.model.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequirementsOverviewReportingTask
extends BaseReportingTask
implements ReportingTask {
    private static final String DEFAULT_REQUIREMENTS_REPORT = "freemarker/requirements.ftl";
    private static final String REPORT_NAME = "capabilities.html";
    protected static final Logger LOGGER = LoggerFactory.getLogger(RequirementsOverviewReportingTask.class);
    private final ReportNameProvider reportNameProvider;
    private final RequirementsOutcomes requirementsOutcomes;
    private final RequirementsService requirementsService;
    private final TestOutcomes testOutcomes;
    private final String relativeLink;
    private final String reportName;
    private boolean asParentRequirement;
    private final RequirementsFilter requirementsFilter;

    public RequirementsOverviewReportingTask(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, ReportNameProvider reportNameProvider, RequirementsService requirementsService, RequirementsOutcomes requirementsOutcomes, String relativeLink, TestOutcomes testOutcomes) {
        super(freemarker, environmentVariables, outputDirectory);
        this.reportNameProvider = reportNameProvider;
        this.requirementsOutcomes = requirementsOutcomes;
        this.requirementsService = requirementsService;
        this.testOutcomes = testOutcomes;
        this.relativeLink = relativeLink;
        this.reportName = REPORT_NAME;
        this.asParentRequirement = true;
        this.requirementsFilter = new RequirementsFilter(environmentVariables);
    }

    public RequirementsOverviewReportingTask(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, ReportNameProvider reportNameProvider, RequirementsService requirementsService, RequirementsOutcomes requirementsOutcomes, String relativeLink, TestOutcomes testOutcomes, String reportName) {
        super(freemarker, environmentVariables, outputDirectory);
        this.reportNameProvider = reportNameProvider;
        this.requirementsOutcomes = requirementsOutcomes;
        this.requirementsService = requirementsService;
        this.testOutcomes = testOutcomes;
        this.relativeLink = relativeLink;
        this.reportName = reportName;
        this.asParentRequirement = true;
        this.requirementsFilter = new RequirementsFilter(environmentVariables);
    }

    @Override
    public String reportName() {
        return this.reportName;
    }

    public RequirementsOverviewReportingTask asParentRequirement() {
        this.asParentRequirement = true;
        return this;
    }

    public RequirementsOverviewReportingTask asLeafRequirement() {
        this.asParentRequirement = false;
        return this;
    }

    @Override
    public void generateReports() throws IOException {
        List<Object> requirements;
        Stopwatch stopwatch = Stopwatch.started();
        Map<String, Object> context = this.freemarker.getBuildContext(this.requirementsOutcomes.getTestOutcomes(), this.reportNameProvider, true);
        String requirementsOverview = this.requirementsOutcomes.getOverview();
        OutcomeTagFilter outcomeFilter = new OutcomeTagFilter(this.environmentVariables);
        if (this.requirementsOutcomes.getParentRequirement().isPresent()) {
            requirements = List.of((Requirement)this.requirementsOutcomes.getParentRequirement().get());
            context.put("requirement", this.requirementsOutcomes.getParentRequirement().get());
            context.put("requirementTags", new TagFilter().removeHiddenTagsFrom((Collection)((Requirement)this.requirementsOutcomes.getParentRequirement().get()).getTags()));
        } else {
            requirements = this.requirementsOutcomes.getRequirementOutcomes().stream().map(RequirementOutcome::getRequirement).collect(Collectors.toList());
        }
        Optional cucumberTags = EnvironmentSpecificConfiguration.from((EnvironmentVariables)this.environmentVariables).getOptionalProperty(new String[]{"cucumber.filter.tags"});
        JSONRequirementsTree requirementsTree = JSONRequirementsTree.forRequirements((List)this.requirementsFilter.filteredByDisplayTag(requirements), (RequirementsOutcomes)this.requirementsOutcomes.filteredByDisplayTag(), (String)cucumberTags.orElse(""));
        if (this.asParentRequirement) {
            requirementsTree = requirementsTree.asAParentRequirement();
        }
        RequirementsOutcomes filteredRequirementsOutcomes = this.requirementsOutcomes.filteredByDisplayTag();
        context.put("requirements", filteredRequirementsOutcomes);
        context.put("duplicateRequirementNamesPresent", DuplicateRequirementNames.presentIn(filteredRequirementsOutcomes));
        context.put("requirementsTree", requirementsTree.asString());
        context.put("requirementsOverview", requirementsOverview);
        context.put("prettyTables", ThucydidesSystemProperty.CUCUMBER_PRETTY_FORMAT_TABLES.booleanFrom(this.environmentVariables, Boolean.valueOf(false)));
        context.put("isLeafRequirement", requirementsTree.isALeafNode());
        context.put("requirementTypes", this.requirementsService.getRequirementTypes());
        TestOutcomes filteredTestOutcomes = this.requirementsOutcomes.getTestOutcomes().filteredByEnvironmentTags();
        context.put("colorScheme", ChartColorScheme.forEnvironment(this.environmentVariables));
        context.put("testOutcomes", filteredTestOutcomes);
        context.put("resultCounts", ResultCountCache.resultCountsFor(this.testOutcomes));
        context.put("requirementCounts", RequirementCounts.forOutcomesIn(this.requirementsOutcomes));
        context.put("allTestOutcomes", this.testOutcomes);
        context.put("timestamp", TestOutcomeTimestamp.from(filteredTestOutcomes));
        context.put("reportName", new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, this.requirementsService));
        context.put("absoluteReportName", new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, this.requirementsService));
        context.put("reportOptions", ReportOptions.forEnvironment((EnvironmentVariables)this.environmentVariables));
        context.put("relativeLink", this.relativeLink);
        context.put("evidence", EvidenceData.from(outcomeFilter.outcomesFilteredByTagIn(filteredTestOutcomes.getOutcomes())));
        this.requirementsOutcomes.getParentRequirement().map(parentRequirement -> context.put("currentTag", parentRequirement.asTag()));
        List scenarios = outcomeFilter.scenariosFilteredByTagIn(ScenarioOutcomes.from((RequirementsOutcomes)this.requirementsOutcomes));
        ArrayList<ScenarioOutcome> scenariosWithoutARule = new ArrayList<ScenarioOutcome>();
        HashMap scenarioOutcomeMap = new HashMap();
        ArrayList<Rule> scenarioRules = new ArrayList<Rule>();
        for (ScenarioOutcome scenario : scenarios) {
            Rule rule = scenario.getRule();
            if (rule == null) {
                scenariosWithoutARule.add(scenario);
                continue;
            }
            if (!scenarioOutcomeMap.containsKey(rule)) {
                scenarioOutcomeMap.put(rule, new ArrayList());
                scenarioRules.add(rule);
            }
            ((List)scenarioOutcomeMap.get(rule)).add(scenario);
        }
        ArrayList<Object> scenarioGroups = new ArrayList<Object>();
        if (!scenariosWithoutARule.isEmpty()) {
            ScenarioOutcomeGroup scenarioGroup = new ScenarioOutcomeGroup(scenariosWithoutARule);
            requirements.stream().filter(requirement -> requirement.getBackground() != null).findFirst().ifPresent(requirement -> {
                scenarioGroup.setBackgroundTitle(requirement.getBackground().getTitle());
                scenarioGroup.setBackgroundDescription(requirement.getBackground().getDescription());
            });
            scenarioGroups.add(scenarioGroup);
        }
        for (Rule rule : scenarioRules) {
            scenarioGroups.add(new ScenarioOutcomeGroup(rule, (List)scenarioOutcomeMap.get(rule)));
        }
        List<ScenarioOutcome> executedScenarios = this.executedScenariosIn(scenarios);
        ScenarioResultCounts scenarioResultCounts = ScenarioResultCounts.forScenarios((List)scenarios);
        context.put("scenarioGroups", scenarioGroups);
        context.put("scenarioResults", scenarioResultCounts);
        context.put("requirementsResultData", scenarioResultCounts.byTypeFor(new String[]{"success", "pending", "ignored", "skipped", "aborted", "failure", "error", "compromised", "undefined"}));
        context.put("testCases", executedScenarios);
        context.put("automatedTestCases", this.automated(executedScenarios));
        context.put("manualTestCases", this.manual(executedScenarios));
        this.addBreadcrumbs(this.requirementsOutcomes, context, new ArrayList<TestTag>(filteredTestOutcomes.getTags()));
        this.generateReportPage(context, DEFAULT_REQUIREMENTS_REPORT, this.reportName);
        LOGGER.trace("Requirements report generated: {} in {} ms", (Object)this.reportName, (Object)stopwatch.stop());
    }

    private List<ScenarioOutcome> automated(List<ScenarioOutcome> executedScenariosIn) {
        return executedScenariosIn.stream().filter(scenarioOutcome -> scenarioOutcome.isManual() == false).collect(Collectors.toList());
    }

    private List<ScenarioOutcome> manual(List<ScenarioOutcome> executedScenariosIn) {
        return executedScenariosIn.stream().filter(ScenarioOutcome::isManual).collect(Collectors.toList());
    }

    private List<ScenarioOutcome> executedScenariosIn(List<ScenarioOutcome> scenarios) {
        return scenarios.stream().filter(scenarioOutcome -> !scenarioOutcome.isBackground()).filter(scenarioOutcome -> !scenarioOutcome.getName().isEmpty()).collect(Collectors.toList());
    }

    private List<ScenarioOutcome> backgroundScenariosIn(List<ScenarioOutcome> scenarios) {
        return scenarios.stream().filter(scenarioOutcome -> scenarioOutcome.isBackground()).filter(scenarioOutcome -> !scenarioOutcome.getName().isEmpty()).collect(Collectors.toList());
    }

    private void addBreadcrumbs(RequirementsOutcomes requirementsOutcomes, Map<String, Object> context, List<TestTag> allTags) {
        if (this.requirementsOutcomes.getParentRequirement().isPresent()) {
            List parents = this.requirementsService.getParentRequirementsOf((Requirement)this.requirementsOutcomes.getParentRequirement().get());
            context.put("breadcrumbs", Breadcrumbs.forParentRequirements(parents));
        } else {
            context.put("breadcrumbs", new BreadcrumbTagFilter().getRequirementBreadcrumbsFrom(requirementsOutcomes));
        }
    }

    public String toString() {
        return "Requirements report " + this.reportName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequirementsOverviewReportingTask that = (RequirementsOverviewReportingTask)o;
        return Objects.equal((Object)this.reportName, (Object)that.reportName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.reportName});
    }
}

