/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class HtmlMinifyingWriter
extends Writer {
    private final Writer delegate;
    private final StringBuilder buffer = new StringBuilder();

    public static Writer minifyingWriter(Path outputPath) throws IOException {
        BufferedWriter baseWriter = Files.newBufferedWriter(outputPath, StandardCharsets.UTF_8, new OpenOption[0]);
        if (outputPath.toString().endsWith(".html")) {
            return new HtmlMinifyingWriter(baseWriter);
        }
        return baseWriter;
    }

    public HtmlMinifyingWriter(Writer delegate) {
        this.delegate = delegate;
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        this.buffer.append(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.compressAndWrite();
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.compressAndWrite();
        this.delegate.close();
    }

    private void compressAndWrite() throws IOException {
        String content = this.buffer.toString();
        String minified = content.replaceAll(">\\s+<", "><").replaceAll("\\s{2,}", " ").replaceAll("^\\s+|\\s+$", "");
        this.delegate.write(minified);
    }
}

