/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.rest;

import com.google.common.collect.ImmutableList;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.specification.RequestSpecification;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import net.serenitybdd.core.rest.RestMethod;
import net.serenitybdd.core.rest.RestQuery;
import net.serenitybdd.rest.QueryPayload;
import net.serenitybdd.rest.RestStepListener;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.InvocationHandler;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepListener;

public class SerenityRest {
    private static ThreadLocal<RestQuery> currentRestQuery = new ThreadLocal();
    private static ThreadLocal<RequestSpecification> currentRequestSpecification = new ThreadLocal();
    private static ThreadLocal<QueryPayload> currentQueryPayload = new ThreadLocal();
    private static final List<String> CONTENT_METHODS = ImmutableList.of((Object)"content", (Object)"body");

    public static void clearQueryData() {
        currentRequestSpecification.remove();
        currentRestQuery.remove();
    }

    public static QueryPayload currentQueryPayload() {
        if (currentQueryPayload.get() == null) {
            currentQueryPayload.set(new QueryPayload());
        }
        return currentQueryPayload.get();
    }

    public static RequestSpecification rest() {
        currentRequestSpecification.set(SerenityRest.instrumentedRequestSpecification());
        StepEventBus.getEventBus().registerListener((StepListener)new RestStepListener());
        return currentRequestSpecification.get();
    }

    public static RequestSpecification then() {
        if (currentRequestSpecification.get() == null) {
            return SerenityRest.rest();
        }
        return currentRequestSpecification.get();
    }

    private static RequestSpecification instrumentedRequestSpecification() {
        RequestSpecification specification = RestAssured.given();
        return SerenityRest.instrumentedRequestSpecificationFor(specification);
    }

    private static RequestSpecification instrumentedRequestSpecificationFor(final RequestSpecification requestSpecification) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(RequestSpecification.class);
        enhancer.setCallback((Callback)new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (RestMethod.restMethodCalled((String)method.getName()).isPresent()) {
                    SerenityRest.notifyRestMethodCall(args, (RestMethod)RestMethod.restMethodCalled((String)method.getName()).get());
                } else if (SerenityRest.definesContent(method.getName())) {
                    SerenityRest.recordContent(method.getName(), args);
                }
                return SerenityRest.wrappedResult(method, requestSpecification, args);
            }
        });
        return (RequestSpecification)enhancer.create();
    }

    private static boolean definesContent(String name) {
        return CONTENT_METHODS.contains(name.toLowerCase()) || name.equalsIgnoreCase("contentType");
    }

    private static void recordContent(String name, Object[] args) {
        switch (name) {
            case "content": 
            case "body": {
                SerenityRest.registerContent(args[0].toString());
                break;
            }
            case "contentType": {
                SerenityRest.registerContentType(args[0].toString());
            }
        }
    }

    private static void registerContentType(String contentType) {
        SerenityRest.currentQueryPayload().setContentType(contentType);
    }

    private static void registerContent(String content) {
        SerenityRest.currentQueryPayload().setContent(content);
    }

    private static void notifyRestMethodCall(Object[] args, RestMethod methodType) {
        switch (methodType) {
            case GET: 
            case DELETE: {
                SerenityRest.notifyGetOrDelete(args, methodType);
                break;
            }
            case POST: 
            case PUT: {
                SerenityRest.notifyPostOrPut(args, methodType);
            }
        }
    }

    private static Object wrappedResult(Method method, Object target, Object[] args) {
        try {
            method.setAccessible(true);
            Object result = method.invoke(target, args);
            if (result == null) {
                return null;
            }
            if (RequestSpecification.class.isAssignableFrom(result.getClass())) {
                currentRequestSpecification.set(SerenityRest.instrumentedRequestSpecificationFor((RequestSpecification)result));
                return currentRequestSpecification.get();
            }
            if (Response.class.isAssignableFrom(result.getClass())) {
                SerenityRest.notifyResponse((Response)result);
                return result;
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void notifyResponse(Response result) {
        String responseBody = result.prettyPrint();
        int statusCode = result.statusCode();
        if (currentRestQuery.get() != null) {
            RestQuery query = currentRestQuery.get();
            query = query.withResponse(responseBody).withStatusCode(Integer.valueOf(statusCode));
            StepEventBus.getEventBus().getBaseStepListener().recordRestQuery(query);
            currentRestQuery.remove();
        }
    }

    private static void notifyGetOrDelete(Object[] args, RestMethod method) {
        String path = args.length == 0 ? RestAssured.basePath : args[0].toString();
        RestQuery query = RestQuery.withMethod((RestMethod)method).andPath(path);
        if (SerenityRest.queryHasParameters(args)) {
            query = SerenityRest.hasParameterMap(args) ? query.withParameters(SerenityRest.mapParameters(args)) : query.withParameters(SerenityRest.listParameters(args));
        }
        currentRestQuery.set(query);
    }

    private static void notifyPostOrPut(Object[] args, RestMethod method) {
        String path = args.length == 0 ? RestAssured.basePath : args[0].toString();
        RestQuery query = RestQuery.withMethod((RestMethod)method).andPath(path);
        if (SerenityRest.queryHasParameters(args)) {
            RestQuery restQuery = query = SerenityRest.hasParameterMap(args) ? query.withParameters(SerenityRest.mapParameters(args)) : query.withParameters(SerenityRest.listParameters(args));
        }
        if (SerenityRest.currentQueryPayload() != null) {
            if (SerenityRest.currentQueryPayload().getContentType() != null) {
                query = query.withContentType(SerenityRest.currentQueryPayload().getContentType());
            }
            if (SerenityRest.currentQueryPayload().getContent() != null) {
                query = query.withContent(SerenityRest.currentQueryPayload().getContent());
            }
        }
        currentRestQuery.set(query);
    }

    private static boolean hasParameterMap(Object[] args) {
        return args[1] instanceof Map;
    }

    private static Map<String, ?> mapParameters(Object[] args) {
        return (Map)args[1];
    }

    private static List<Object> listParameters(Object[] args) {
        return ImmutableList.copyOf((Object[])((Object[])args[1]));
    }

    private static boolean queryHasParameters(Object[] args) {
        if (args.length <= 1) {
            return false;
        }
        if (args[1].getClass().isArray()) {
            return ((Object[])args[1]).length > 0;
        }
        if (args[1] instanceof Map) {
            return !((Map)args[1]).isEmpty();
        }
        return false;
    }
}

