/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.rest.utils;

import com.jayway.restassured.filter.log.LogDetail;
import com.jayway.restassured.internal.RequestSpecificationImpl;
import com.jayway.restassured.internal.ResponseSpecificationImpl;
import com.jayway.restassured.internal.filter.SendRequestFilter;
import com.jayway.restassured.specification.RequestSpecification;
import com.jayway.restassured.specification.ResponseSpecification;
import java.util.Arrays;
import java.util.LinkedList;
import net.serenitybdd.rest.decorators.ResponseSpecificationDecorated;
import net.serenitybdd.rest.decorators.request.RequestSpecificationDecorated;
import net.serenitybdd.rest.filters.FieldsRecordingFilter;
import net.serenitybdd.rest.filters.UpdatingContextFilter;
import net.serenitybdd.rest.utils.RestExecutionHelper;

public class RestDecorationHelper {
    public static RequestSpecification decorate(RequestSpecification specification) {
        if (specification instanceof RequestSpecificationDecorated) {
            return specification;
        }
        if (specification instanceof RequestSpecificationImpl) {
            RequestSpecificationDecorated decorated = new RequestSpecificationDecorated((RequestSpecificationImpl)specification);
            LinkedList<Object> filters = new LinkedList<Object>();
            for (LogDetail logDetail : Arrays.asList(LogDetail.HEADERS, LogDetail.COOKIES, LogDetail.BODY, LogDetail.PARAMS, LogDetail.METHOD, LogDetail.PATH)) {
                filters.add(new FieldsRecordingFilter(true, logDetail));
            }
            if (RestExecutionHelper.restCallsAreEnabled()) {
                filters.add(new UpdatingContextFilter(SendRequestFilter.class));
            }
            decorated.filters(filters);
            return decorated;
        }
        throw new IllegalArgumentException("Can not be used custom Request Specification Implementation");
    }

    public static ResponseSpecification decorate(ResponseSpecification specification) {
        if (specification instanceof ResponseSpecificationDecorated) {
            return specification;
        }
        if (specification instanceof ResponseSpecificationImpl) {
            return new ResponseSpecificationDecorated((ResponseSpecificationImpl)specification);
        }
        throw new IllegalArgumentException("Can not be used custom Response Specification Implementation");
    }
}

