/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.rest.utils;

import io.restassured.filter.log.LogDetail;
import io.restassured.internal.RequestSpecificationImpl;
import io.restassured.internal.ResponseSpecificationImpl;
import io.restassured.internal.filter.SendRequestFilter;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.FilterableResponseSpecification;
import io.restassured.specification.RequestSenderOptions;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.LinkedList;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.serenitybdd.rest.SerenityRest;
import net.serenitybdd.rest.decorators.ResponseSpecificationDecorated;
import net.serenitybdd.rest.decorators.request.RequestSpecificationDecorated;
import net.serenitybdd.rest.filters.FieldsRecordingFilter;
import net.serenitybdd.rest.filters.UpdatingContextFilter;
import net.serenitybdd.rest.utils.RequestSpecificationDecoratedFactory;
import net.serenitybdd.rest.utils.ResponseSpecificationDecoratedFactory;
import net.serenitybdd.rest.utils.RestExecutionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestSpecificationFactory {
    private static final Logger log = LoggerFactory.getLogger(RestSpecificationFactory.class);
    private static Constructor<?> requestSpecificationDecoratedConstructor;
    private static Constructor<?> responseSpecificationDecoratedConstructor;
    private static RequestSpecificationDecoratedFactory requestSpecificationDecoratedFactory;
    private static ResponseSpecificationDecoratedFactory responseSpecificationDecoratedFactory;

    public static RequestSpecificationDecorated getInstrumentedRequestSpecification(RequestSpecificationImpl delegate) {
        RequestSpecificationDecorated instrumentedResponse = requestSpecificationDecoratedFactory.create(delegate);
        LinkedList<Object> filters = new LinkedList<Object>();
        for (LogDetail logDetail : Arrays.asList(LogDetail.HEADERS, LogDetail.COOKIES, LogDetail.BODY, LogDetail.PARAMS, LogDetail.METHOD, LogDetail.URI)) {
            filters.add(new FieldsRecordingFilter(true, logDetail));
        }
        if (RestExecutionHelper.restCallsAreEnabled()) {
            filters.add(new UpdatingContextFilter(SendRequestFilter.class));
        }
        instrumentedResponse.filters(filters);
        return instrumentedResponse;
    }

    public static ResponseSpecificationDecorated getInstrumentedResponseSpecification(ResponseSpecificationImpl delegate) {
        return responseSpecificationDecoratedFactory.create(delegate);
    }

    static {
        Class requestSpecificationDecoratedClass = new ByteBuddy().subclass(RequestSpecificationDecorated.class).method((ElementMatcher)ElementMatchers.isDeclaredBy(RequestSpecification.class).or((ElementMatcher)ElementMatchers.isDeclaredBy(RequestSenderOptions.class)).or((ElementMatcher)ElementMatchers.isDeclaredBy(FilterableRequestSpecification.class))).intercept((Implementation)MethodDelegation.toField((String)"core")).make().load(SerenityRest.class.getClassLoader()).getLoaded();
        Class responseSpecificationDecoratedClass = new ByteBuddy().subclass(ResponseSpecificationDecorated.class).method((ElementMatcher)ElementMatchers.isDeclaredBy(ResponseSpecification.class).or((ElementMatcher)ElementMatchers.isDeclaredBy(RequestSenderOptions.class)).or((ElementMatcher)ElementMatchers.isDeclaredBy(FilterableResponseSpecification.class))).intercept((Implementation)MethodDelegation.toField((String)"core")).make().load(SerenityRest.class.getClassLoader()).getLoaded();
        try {
            requestSpecificationDecoratedConstructor = requestSpecificationDecoratedClass.getConstructor(RequestSpecificationImpl.class);
        }
        catch (NoSuchMethodException e) {
            log.error("Cannot found constructor for RequestSpecificationDecorated ", (Throwable)e);
        }
        try {
            responseSpecificationDecoratedConstructor = responseSpecificationDecoratedClass.getConstructor(ResponseSpecificationImpl.class);
        }
        catch (NoSuchMethodException e) {
            log.error("Cannot found constructor for ResponseSpecificationDecorated ", (Throwable)e);
        }
        try {
            requestSpecificationDecoratedFactory = (RequestSpecificationDecoratedFactory)new ByteBuddy().subclass(RequestSpecificationDecoratedFactory.class).method((ElementMatcher)ElementMatchers.isDeclaredBy(RequestSpecificationDecoratedFactory.class)).intercept((Implementation)MethodCall.construct(requestSpecificationDecoratedConstructor).withArgument(new int[]{0})).make().load(requestSpecificationDecoratedClass.getClassLoader()).getLoaded().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("Cannot create requestSpecificationDecoratedFactory ", (Throwable)e);
        }
        try {
            responseSpecificationDecoratedFactory = (ResponseSpecificationDecoratedFactory)new ByteBuddy().subclass(ResponseSpecificationDecoratedFactory.class).method((ElementMatcher)ElementMatchers.isDeclaredBy(ResponseSpecificationDecoratedFactory.class)).intercept((Implementation)MethodCall.construct(responseSpecificationDecoratedConstructor).withArgument(new int[]{0})).make().load(responseSpecificationDecoratedClass.getClassLoader()).getLoaded().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("Cannot create responseSpecificationDecoratedFactory ", (Throwable)e);
        }
    }
}

