/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.rest.decorators.request;

import io.restassured.authentication.AuthenticationScheme;
import io.restassured.config.RestAssuredConfig;
import io.restassured.internal.AuthenticationSpecificationImpl;
import io.restassured.internal.RequestSpecificationImpl;
import io.restassured.specification.AuthenticationSpecification;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.RequestSpecification;
import java.io.File;
import java.security.KeyStore;
import net.serenitybdd.rest.decorators.request.RequestSpecificationProxyConfigurations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class RequestSpecificationSecurityConfigurations
extends RequestSpecificationProxyConfigurations
implements FilterableRequestSpecification {
    private static final Logger log = LoggerFactory.getLogger(RequestSpecificationSecurityConfigurations.class);

    public RequestSpecificationSecurityConfigurations(RequestSpecificationImpl core) {
        super(core);
    }

    public RequestSpecification keyStore(String pathToJks, String password) {
        this.core.keyStore(pathToJks, password);
        return this;
    }

    public RequestSpecification keyStore(File pathToJks, String password) {
        this.core.keyStore(pathToJks, password);
        return this;
    }

    public RequestSpecification trustStore(KeyStore trustStore) {
        this.core.trustStore(trustStore);
        return this;
    }

    public RequestSpecification relaxedHTTPSValidation() {
        String protocol = "SSL";
        try {
            protocol = (String)this.helper.getValueFrom("SSL");
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            log.error("Error when getting value of SSL field from RequestSpecification");
            protocol = "SSL";
        }
        return this.relaxedHTTPSValidation(protocol);
    }

    public RequestSpecification relaxedHTTPSValidation(String protocol) {
        this.core.relaxedHTTPSValidation(protocol);
        return this;
    }

    public AuthenticationSpecification authentication() {
        return new AuthenticationSpecificationImpl((RequestSpecification)this);
    }

    public AuthenticationSpecification auth() {
        return this.authentication();
    }

    protected void setAuthenticationScheme(AuthenticationScheme scheme) {
        try {
            this.helper.setValueTo("authenticationScheme", scheme);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not set authenticationScheme from request, SerenityRest can work incorrectly");
        }
    }

    protected RestAssuredConfig setauthenticationScheme() {
        return this.getRestAssuredConfig();
    }
}

