/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.rest.filters;

import io.restassured.filter.Filter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SkipClassIterator
implements Iterator<Filter> {
    private final Set<Class> skipping = new HashSet<Class>();
    private final Iterator<Filter> core;

    public SkipClassIterator(Iterator<Filter> iterator, Class ... skip) {
        this(iterator, Arrays.asList(skip));
    }

    public SkipClassIterator(Iterator<Filter> iterator, Collection<Class> skipping) {
        this.core = iterator;
        this.skipping.addAll(skipping);
    }

    @Override
    public boolean hasNext() {
        if (this.core.hasNext()) {
            Filter filter = this.core.next();
            for (Class search : this.skipping) {
                if (!filter.getClass().isAssignableFrom(search)) continue;
                return this.hasNext();
            }
            return true;
        }
        return false;
    }

    @Override
    public Filter next() {
        return this.core.next();
    }

    @Override
    public void remove() {
        this.core.remove();
    }
}

