/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.rest.filters;

import io.restassured.filter.Filter;
import io.restassured.filter.FilterContext;
import io.restassured.filter.log.LogDetail;
import io.restassured.filter.log.RequestLoggingFilter;
import io.restassured.response.Response;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.FilterableResponseSpecification;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

public class FieldsRecordingFilter
implements Filter {
    private final LogDetail logDetail;
    private final boolean shouldPrettyPrint;
    private String recorded = "";

    public FieldsRecordingFilter(boolean shouldPrettyPrint, LogDetail detail) {
        this.logDetail = detail;
        this.shouldPrettyPrint = shouldPrettyPrint;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Response filter(FilterableRequestSpecification requestSpec, FilterableResponseSpecification responseSpec, FilterContext ctx) {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            PrintStream recordingStream = new PrintStream((OutputStream)output, true, StandardCharsets.UTF_8.toString());
            try {
                RequestLoggingFilter filter = new RequestLoggingFilter(this.logDetail, this.shouldPrettyPrint, recordingStream);
                Response response = filter.filter(requestSpec, responseSpec, ctx);
                recordingStream.flush();
                this.recorded = new String(output.toByteArray(), StandardCharsets.UTF_8);
                this.recorded = this.recorded.replaceAll("^((Proxy:)|(Body:)|(Cookies:)|(Headers:)|(Multiparts:)|(Request path:))\\s*\\n*", "");
                this.recorded = this.recorded.replaceAll("^(<none>)", "");
                this.recorded = this.recorded.replaceAll("\n$", "");
                Response response2 = response;
                recordingStream.close();
                return response2;
            }
            catch (Throwable throwable) {
                try {
                    recordingStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Incorrect implementation, should be used correct charset", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Some exception during recording fields", e);
        }
    }

    public LogDetail logDetail() {
        return this.logDetail;
    }

    public String recorded() {
        return this.recorded;
    }
}

