/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.rest.utils;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;

public class RestExecutionHelper {
    private static Set<String> classWithDryCleanEnabled = Collections.newSetFromMap(new ConcurrentHashMap());

    public static boolean restCallsAreDisabled() {
        EnvironmentVariables environmentVariables = SystemEnvironmentVariables.currentEnvironmentVariables();
        if (!ThucydidesSystemProperty.SERENITY_DISABLE_REST_CALLS_AFTER_FAILURES.booleanFrom(environmentVariables, Boolean.valueOf(true)).booleanValue()) {
            return false;
        }
        return RestExecutionHelper.isEnabledDryCleanOnlyForCurrentClass() || StepEventBus.getEventBus().isDryRun() || StepEventBus.getEventBus().currentTestIsSuspended();
    }

    public static void enableDryRunForClass(Object object) {
        RestExecutionHelper.enableDryRunForClass(object.getClass());
    }

    public static void enableDryRunForClass(Class classOfObject) {
        classWithDryCleanEnabled.add(classOfObject.getName());
    }

    public static void disableDryRunForClass(Object object) {
        RestExecutionHelper.enableDryRunForClass(object.getClass());
    }

    public static void disableDryRunForClass(Class classOfObject) {
        classWithDryCleanEnabled.remove(classOfObject.getName());
    }

    private static boolean isEnabledDryCleanOnlyForCurrentClass() {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!classWithDryCleanEnabled.contains(element.getClassName())) continue;
            return true;
        }
        return false;
    }
}

