/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.rest;

import io.restassured.response.ValidatableResponse;
import java.util.function.Consumer;
import net.serenitybdd.rest.SerenityRest;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.events.StepEventBusEvent;
import net.thucydides.core.steps.events.StepFailedEvent;
import net.thucydides.core.steps.events.StepFinishedEvent;
import net.thucydides.core.steps.events.StepStartedEvent;
import net.thucydides.core.steps.session.TestSession;

public class Ensure {
    public static Ensure that(String description, Consumer<ValidatableResponse> check) {
        Ensure ensure = new Ensure();
        ensure.performCheck(description, check, "Ensure that ");
        return ensure;
    }

    public Ensure andThat(String description, Consumer<ValidatableResponse> check) {
        this.performCheck(description, check, "And that ");
        return this;
    }

    private void performCheck(String description, Consumer<ValidatableResponse> check, String prefix) {
        if (TestSession.isSessionStarted()) {
            Ensure.doPerformAsynchronousCheck(description, check, prefix);
        } else {
            Ensure.doPerformSynchronousCheck(description, check, prefix);
        }
    }

    private static void doPerformAsynchronousCheck(String description, Consumer<ValidatableResponse> check, String prefix) {
        TestSession.addEvent((StepEventBusEvent)new StepStartedEvent(ExecutedStepDescription.withTitle((String)(prefix + description))));
        try {
            check.accept(SerenityRest.then());
        }
        catch (Throwable e) {
            TestSession.addEvent((StepEventBusEvent)new StepFailedEvent(new StepFailure(ExecutedStepDescription.withTitle((String)description), e)));
            return;
        }
        TestSession.addEvent((StepEventBusEvent)new StepFinishedEvent());
    }

    private static void doPerformSynchronousCheck(String description, Consumer<ValidatableResponse> check, String prefix) {
        StepEventBus.getParallelEventBus().stepStarted(ExecutedStepDescription.withTitle((String)(prefix + description)));
        try {
            check.accept(SerenityRest.then());
        }
        catch (Throwable e) {
            StepEventBus.getParallelEventBus().stepFailed(new StepFailure(ExecutedStepDescription.withTitle((String)description), e));
            return;
        }
        StepEventBus.getParallelEventBus().stepFinished();
    }
}

