/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.rest.filters;

import io.restassured.filter.Filter;
import io.restassured.filter.FilterContext;
import io.restassured.internal.filter.FilterContextImpl;
import io.restassured.response.Response;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.FilterableResponseSpecification;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.serenitybdd.rest.filters.SkipClassIterator;
import net.serenitybdd.rest.stubs.ResponseStub;
import net.serenitybdd.rest.utils.ReflectionHelper;
import net.serenitybdd.rest.utils.RestExecutionHelper;
import net.serenitybdd.rest.utils.RestRuntimeException;

public class UpdatingContextFilter
implements Filter {
    private final Set<Class> skipping = new HashSet<Class>();

    public UpdatingContextFilter(Class ... skip) {
        this.skipping.addAll(Arrays.asList(skip));
    }

    public Response filter(FilterableRequestSpecification requestSpec, FilterableResponseSpecification responseSpec, FilterContext ctx) {
        try {
            ReflectionHelper<FilterContextImpl> helper = new ReflectionHelper<FilterContextImpl>((FilterContextImpl)ctx);
            Object iterator = helper.getValueFrom("filters");
            helper.setValueTo("filters", new SkipClassIterator((Iterator<Filter>)((Iterator)iterator), this.skipping));
            return ctx.next(requestSpec, responseSpec);
        }
        catch (Throwable e) {
            if (RestExecutionHelper.restCallsAreDisabled()) {
                return this.stubbed();
            }
            throw new RestRuntimeException("Incorrect implementation, should update field without any problem", e);
        }
    }

    private Response stubbed() {
        return new ResponseStub();
    }
}

