/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.rest;

import io.restassured.http.ContentType;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public enum DecomposedContentType {
    ANY("*/*", ContentType.ANY),
    TEXT("text/plain", ContentType.TEXT),
    APPLICATION_JSON("application/json", ContentType.JSON),
    APPLICATION_JAVASCRIPT("application/javascript", ContentType.JSON),
    APPLICATION_XML("application/xml", ContentType.XML),
    TEST_XML("text/xml", ContentType.XML),
    APPLICATION_XHTML_XML("application/xhtml+xml", ContentType.XML),
    TEST_JAVASCRIPT("text/javascript", ContentType.JSON),
    HTML("text/html", ContentType.HTML),
    URLENC("application/x-www-form-urlencoded", ContentType.URLENC),
    BINARY("application/octet-stream", ContentType.BINARY);

    private String representation;
    private ContentType type;
    private static Map<String, DecomposedContentType> declared;

    private DecomposedContentType(String representation, ContentType type) {
        this.representation = representation;
        this.type = type;
        DecomposedContentType.register(representation, this);
    }

    private static void register(String representation, DecomposedContentType decomposedContentType) {
        if (declared == null) {
            declared = new HashMap<String, DecomposedContentType>();
        }
        declared.put(DecomposedContentType.normalize(representation), decomposedContentType);
    }

    private static String normalize(String value) {
        return StringUtils.lowerCase((String)((String)ObjectUtils.firstNonNull((Object[])new String[]{value, ""})).replaceAll("\\s*", ""));
    }

    public DecomposedContentType byString(String string) {
        String normalized = DecomposedContentType.normalize((String)ObjectUtils.firstNonNull((Object[])new String[]{string, ""}));
        DecomposedContentType decomposedContentType = declared.get(normalized);
        if (decomposedContentType == null) {
            for (Map.Entry<String, DecomposedContentType> contentTypeEntry : declared.entrySet()) {
                if (!normalized.contains(contentTypeEntry.getKey())) continue;
                decomposedContentType = contentTypeEntry.getValue();
            }
        }
        return decomposedContentType;
    }

    public String toString() {
        return this.representation;
    }

    public String asString() {
        return this.representation;
    }

    public ContentType contentType() {
        return this.type;
    }
}

