/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.saucelabs;

import java.util.Optional;
import net.serenitybdd.model.environment.EnvironmentSpecificConfiguration;
import net.thucydides.model.util.EnvironmentVariables;

class SauceLabsCredentials {
    private final EnvironmentVariables environmentVariables;

    public SauceLabsCredentials(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public static SauceLabsCredentials from(EnvironmentVariables environmentVariables) {
        return new SauceLabsCredentials(environmentVariables);
    }

    public String getUser() {
        String userDefinedInSerenityConf = EnvironmentSpecificConfiguration.from((EnvironmentVariables)this.environmentVariables).getOptionalProperty(new String[]{"saucelabs.username", "sauce.username"}).orElse("");
        return Optional.ofNullable(this.environmentVariables.getValue("SAUCE_USERNAME")).orElse(userDefinedInSerenityConf);
    }

    public String getAccessKey() {
        String keyDefinedInSerenityConf = EnvironmentSpecificConfiguration.from((EnvironmentVariables)this.environmentVariables).getOptionalProperty(new String[]{"saucelabs.accessKey", "sauce.key"}).orElse("");
        return Optional.ofNullable(this.environmentVariables.getValue("SAUCE_ACCESS_KEY")).orElse(keyDefinedInSerenityConf);
    }

    public boolean areDefined() {
        return !this.getUser().isEmpty() && !this.getAccessKey().isEmpty();
    }
}

