/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.saucelabs;

import com.typesafe.config.ConfigValue;
import java.util.HashMap;
import java.util.Optional;
import net.serenitybdd.core.environment.CustomDriverConfig;
import net.serenitybdd.core.webdriver.enhancers.BeforeAWebdriverScenario;
import net.serenitybdd.model.environment.EnvironmentSpecificConfiguration;
import net.serenitybdd.model.model.TestOutcomeName;
import net.serenitybdd.plugins.saucelabs.SauceLabsConfiguration;
import net.serenitybdd.plugins.saucelabs.SauceLabsCredentials;
import net.serenitybdd.plugins.saucelabs.SauceLabsUri;
import net.thucydides.core.steps.session.TestSession;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.environment.TestLocalEnvironmentVariables;
import net.thucydides.model.util.EnvironmentVariables;
import org.openqa.selenium.MutableCapabilities;

public class BeforeASauceLabsScenario
implements BeforeAWebdriverScenario {
    private static final String SAUCE_OPTIONS = "\"sauce:options\"";
    private static final String SAUCE_CAPABILITY = "sauce:options";

    public MutableCapabilities apply(EnvironmentVariables environmentVariables, SupportedWebDriver driver, TestOutcome testOutcome, MutableCapabilities capabilities) {
        if (!SauceLabsConfiguration.isActiveFor(environmentVariables)) {
            return capabilities;
        }
        Optional remoteUrl = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(ThucydidesSystemProperty.WEBDRIVER_REMOTE_URL);
        if (!remoteUrl.isPresent()) {
            String sauceRemoteUrl = SauceLabsUri.definedIn(environmentVariables).getUri();
            TestLocalEnvironmentVariables.setProperty((String)ThucydidesSystemProperty.WEBDRIVER_REMOTE_URL.getPropertyName(), (String)sauceRemoteUrl);
        }
        HashMap<String, String> newOptions = new HashMap<String, String>();
        String testName = TestOutcomeName.from((TestOutcome)testOutcome);
        if (TestSession.isSessionStarted()) {
            testName = TestSession.getTestSessionContext().getCurrentTestName();
        }
        CustomDriverConfig.webdriverCapabilitiesConfig((EnvironmentVariables)environmentVariables, (String)SAUCE_OPTIONS).ifPresent(options -> options.entrySet().forEach(entry -> newOptions.put((String)entry.getKey(), (String)((ConfigValue)entry.getValue()).unwrapped())));
        newOptions.put("username", SauceLabsCredentials.from(environmentVariables).getUser());
        newOptions.put("accessKey", SauceLabsCredentials.from(environmentVariables).getAccessKey());
        newOptions.put("name", testName);
        String context = CustomDriverConfig.fetchContextFrom((MutableCapabilities)capabilities, (EnvironmentVariables)environmentVariables, (String)SAUCE_OPTIONS);
        testOutcome.setContext(context);
        capabilities.setCapability(SAUCE_CAPABILITY, newOptions);
        return capabilities;
    }

    public boolean isActivated(EnvironmentVariables environmentVariables) {
        return SauceLabsConfiguration.isActiveFor(environmentVariables);
    }
}

