/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.saucelabs;

import net.serenitybdd.core.webdriver.RemoteDriver;
import net.serenitybdd.model.environment.EnvironmentSpecificConfiguration;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.model.util.EnvironmentVariables;
import org.openqa.selenium.WebDriver;

class SauceLabsConfiguration {
    public static final String SAUCELABS_OPTIONS = "\"sauce:options\"";
    public static final String SAUCELABS_OPTIONS_PATH = "webdriver.capabilities.\"sauce:options\"";

    SauceLabsConfiguration() {
    }

    static boolean isActiveFor(EnvironmentVariables environmentVariables) {
        if (EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getBooleanProperty("sauce.active", false)) {
            return true;
        }
        if (!EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getPropertiesWithPrefix(SAUCELABS_OPTIONS_PATH).isEmpty()) {
            return true;
        }
        return EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(new String[]{"webdriver.remote.url"}).orElse("").contains("saucelabs");
    }

    public static boolean isDriverEnabled(WebDriver driver) {
        if (driver == null || !RemoteDriver.isARemoteDriver((WebDriver)driver) || RemoteDriver.isStubbed((WebDriver)driver)) {
            return false;
        }
        if (driver instanceof WebDriverFacade) {
            return ((WebDriverFacade)driver).isInstantiated();
        }
        return true;
    }
}

