/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.saucelabs;

import net.serenitybdd.model.environment.EnvironmentSpecificConfiguration;
import net.serenitybdd.plugins.saucelabs.SauceLabsCredentials;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SauceLabsUri {
    private final EnvironmentVariables environmentVariables;
    private static final Logger LOGGER = LoggerFactory.getLogger(SauceLabsUri.class);
    private final String username;
    private final String accessKey;
    private static final String SAUCELABS_HUB = "https://ondemand.#{saucelabs.datacenter}.saucelabs.com/wd/hub";

    public SauceLabsUri(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.username = SauceLabsCredentials.from(environmentVariables).getUser();
        this.accessKey = SauceLabsCredentials.from(environmentVariables).getAccessKey();
    }

    public static SauceLabsUri definedIn(EnvironmentVariables environmentVariables) {
        return new SauceLabsUri(environmentVariables);
    }

    public String getUri() {
        String remoteUrl = EnvironmentSpecificConfiguration.from((EnvironmentVariables)this.environmentVariables).getNullableProperty(ThucydidesSystemProperty.WEBDRIVER_REMOTE_URL);
        if (remoteUrl != null) {
            return remoteUrl;
        }
        if (this.username.isEmpty() || this.accessKey.isEmpty()) {
            LOGGER.warn("It looks like you are trying to connect to BrowserStack, but you haven't defined any credentials. You can set your BrowserStack username and access key either in the BROWSERSTACK_USERNAME and BROWSERSTACK_AUTOMATE_KEY system environment variables, or in the browserstack.username and browserstack.automate.key properties in your serenity.conf file");
            return null;
        }
        return "https://" + this.username + ":" + this.accessKey + SAUCELABS_HUB;
    }
}

