/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.playwright.abilities;

import com.google.common.eventbus.Subscribe;
import com.microsoft.playwright.Browser;
import com.microsoft.playwright.BrowserContext;
import com.microsoft.playwright.BrowserType;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.Playwright;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.serenitybdd.core.eventbus.Broadcaster;
import net.serenitybdd.screenplay.Ability;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.RefersToActor;
import net.serenitybdd.screenplay.events.ActorAsksQuestion;
import net.serenitybdd.screenplay.events.ActorBeginsPerformanceEvent;
import net.serenitybdd.screenplay.events.ActorEndsPerformanceEvent;
import net.serenitybdd.screenplay.events.ActorPerformanceEvent;
import net.serenitybdd.screenplay.events.ActorPerforms;
import net.serenitybdd.screenplay.playwright.PlayWrightConfigurationProperties;
import net.serenitybdd.screenplay.playwright.abilities.ActorCannotUsePlaywrightException;
import net.serenitybdd.screenplay.playwright.abilities.InvalidPlaywrightBrowserType;
import net.thucydides.core.events.TestLifecycleEvents;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;

public class BrowseTheWebWithPlaywright
implements Ability,
RefersToActor {
    private Actor actor;
    Playwright playwright;
    BrowserType.LaunchOptions options;
    private Optional<String> browserType;
    private static final String DEFAULT_BROWSER_TYPE = "chromium";
    private Browser browser;
    private BrowserContext currentContext;
    private Page currentPage;
    private EnvironmentVariables environmentVariables;
    private static final Map<String, Function<Playwright, BrowserType>> OPEN_BROWSER = new HashMap<String, Function<Playwright, BrowserType>>();

    protected BrowseTheWebWithPlaywright(EnvironmentVariables environmentVariables) {
        this(environmentVariables, new BrowserType.LaunchOptions(), PlayWrightConfigurationProperties.BROWSER_TYPE.asStringFrom(environmentVariables).orElse(null));
    }

    protected BrowseTheWebWithPlaywright(EnvironmentVariables environmentVariables, BrowserType.LaunchOptions options) {
        this(environmentVariables, options, null);
    }

    protected BrowseTheWebWithPlaywright(EnvironmentVariables environmentVariables, BrowserType.LaunchOptions options, String browserType) {
        this.environmentVariables = environmentVariables;
        this.options = options;
        this.browserType = Optional.ofNullable(browserType);
        this.registerForEventNotification();
    }

    private void registerForEventNotification() {
        Broadcaster.getEventBus().register((Object)this);
        TestLifecycleEvents.register((Object)this);
    }

    public static BrowseTheWebWithPlaywright as(Actor actor) {
        if (actor.abilityTo(BrowseTheWebWithPlaywright.class) == null) {
            throw new ActorCannotUsePlaywrightException(actor.getName());
        }
        return (BrowseTheWebWithPlaywright)((BrowseTheWebWithPlaywright)actor.abilityTo(BrowseTheWebWithPlaywright.class)).asActor(actor);
    }

    public Browser getBrowser() {
        if (this.browser == null) {
            this.browser = this.initialiseBrowser();
        }
        return this.browser;
    }

    private BrowserContext getCurrentContext() {
        if (this.currentContext == null) {
            this.currentContext = this.getBrowser().newContext();
        }
        return this.currentContext;
    }

    public Page getCurrentPage() {
        if (this.currentPage == null) {
            this.currentPage = this.getCurrentContext().newPage();
        }
        return this.currentPage;
    }

    private Browser initialiseBrowser() {
        if (this.playwright == null) {
            this.playwright = Playwright.create();
        }
        BrowserType.LaunchOptions options = this.launchOptionsDefinedIn(this.environmentVariables);
        if (!OPEN_BROWSER.containsKey(this.configuredBrowser())) {
            throw new InvalidPlaywrightBrowserType(this.configuredBrowser());
        }
        return OPEN_BROWSER.get(this.configuredBrowser()).apply(this.playwright).launch(options);
    }

    private String configuredBrowser() {
        return this.browserType.orElse(DEFAULT_BROWSER_TYPE);
    }

    private BrowserType.LaunchOptions launchOptionsDefinedIn(EnvironmentVariables environmentVariables) {
        block19: {
            block18: {
                if (this.options.args == null) {
                    PlayWrightConfigurationProperties.ARGS.asListOfStringsFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.options).setArgs(arg_0));
                }
                if (this.options.channel == null) {
                    PlayWrightConfigurationProperties.BROWSER_CHANNEL.asBrowserChannelFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.options).setChannel(arg_0));
                }
                if (this.options.chromiumSandbox == null) {
                    PlayWrightConfigurationProperties.CHROMIUM_SANDBOX.asBooleanFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.options).setChromiumSandbox(arg_0));
                }
                if (this.options.devtools == null) {
                    PlayWrightConfigurationProperties.DEVTOOLS.asBooleanFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.options).setChromiumSandbox(arg_0));
                }
                if (this.options.downloadsPath == null) {
                    PlayWrightConfigurationProperties.DOWNLOADS_PATH.asPathFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.options).setDownloadsPath(arg_0));
                }
                if (this.options.env == null) {
                    PlayWrightConfigurationProperties.ENV.asJsonMapFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.options).setEnv(arg_0));
                }
                if (this.options.executablePath == null) {
                    PlayWrightConfigurationProperties.EXECUTABLE_PATH.asPathFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.options).setExecutablePath(arg_0));
                }
                if (this.options.handleSIGHUP == null) {
                    PlayWrightConfigurationProperties.HANDLE_SIGHUP.asBooleanFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.options).setHandleSIGHUP(arg_0));
                }
                if (this.options.handleSIGINT == null) {
                    PlayWrightConfigurationProperties.HANDLE_SIGINT.asBooleanFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.options).setHandleSIGINT(arg_0));
                }
                if (this.options.handleSIGTERM == null) {
                    PlayWrightConfigurationProperties.HANDLE_SIGTERM.asBooleanFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.options).setHandleSIGTERM(arg_0));
                }
                if (this.options.headless == null) break block18;
                if (this.options.headless.booleanValue()) break block19;
            }
            PlayWrightConfigurationProperties.HEADLESS.asBooleanFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.options).setHeadless(arg_0));
        }
        if (this.options.ignoreAllDefaultArgs == null) {
            PlayWrightConfigurationProperties.IGNORE_ALL_DEFAULT_APPS.asBooleanFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.options).setIgnoreAllDefaultArgs(arg_0));
        }
        if (this.options.ignoreDefaultArgs == null) {
            PlayWrightConfigurationProperties.IGNORE_DEFAULT_APPS.asListOfStringsFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.options).setIgnoreDefaultArgs(arg_0));
        }
        if (this.options.proxy == null) {
            PlayWrightConfigurationProperties.PROXY.asProxyFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.options).setProxy(arg_0));
        }
        if (this.options.slowMo == null) {
            PlayWrightConfigurationProperties.SLOW_MO.asDoubleFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.options).setSlowMo(arg_0));
        }
        if (this.options.timeout == null) {
            PlayWrightConfigurationProperties.TIMEOUT.asDoubleFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.options).setTimeout(arg_0));
        }
        return this.options;
    }

    public <T extends Ability> T asActor(Actor actor) {
        this.actor = actor;
        return (T)this;
    }

    @Subscribe
    public void beginPerformance(ActorBeginsPerformanceEvent performanceEvent) {
        if (this.messageIsForThisActor((ActorPerformanceEvent)performanceEvent)) {
            System.out.println("BEGIN " + performanceEvent.getClass());
        }
    }

    @Subscribe
    public void endPerformance(ActorEndsPerformanceEvent performanceEvent) {
        if (this.messageIsForThisActor((ActorPerformanceEvent)performanceEvent)) {
            System.out.println("END " + performanceEvent.getClass());
        }
    }

    @Subscribe
    public void perform(ActorPerforms performAction) {
        if (this.messageIsForThisActor((ActorPerformanceEvent)performAction)) {
            System.out.println("Perform " + performAction.getPerformable());
        }
    }

    @Subscribe
    public void prepareQuestion(ActorAsksQuestion questionEvent) {
        if (this.messageIsForThisActor((ActorPerformanceEvent)questionEvent)) {
            System.out.println("Question " + questionEvent.getQuestion());
        }
    }

    @Subscribe
    public void testFinishes(TestLifecycleEvents.TestFinished testFinished) {
        if (this.playwright != null) {
            this.playwright.close();
            this.playwright = null;
        }
    }

    private boolean messageIsForThisActor(ActorPerformanceEvent event) {
        return event.getName().equals(this.actor.getName());
    }

    public static BrowseTheWebWithPlaywright usingTheDefaultConfiguration() {
        return new BrowseTheWebWithPlaywright((EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    public static BrowseTheWebWithPlaywright withOptions(BrowserType.LaunchOptions options) {
        return new BrowseTheWebWithPlaywright((EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class), options);
    }

    public BrowseTheWebWithPlaywright withBrowserType(String browserType) {
        return new BrowseTheWebWithPlaywright(this.environmentVariables, this.options, browserType);
    }

    public BrowseTheWebWithPlaywright withHeadlessMode(Boolean headless) {
        return new BrowseTheWebWithPlaywright(this.environmentVariables, this.options.setHeadless(headless.booleanValue()), this.browserType.orElse(null));
    }

    static {
        OPEN_BROWSER.put(DEFAULT_BROWSER_TYPE, Playwright::chromium);
        OPEN_BROWSER.put("webkit", Playwright::webkit);
        OPEN_BROWSER.put("firefox", Playwright::firefox);
    }
}

