/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.playwright;

import com.microsoft.playwright.Page;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.StepEventBus;
import org.assertj.core.api.Assertions;

public class Photographer {
    public File takesAScreenshot(Page currentPage) {
        BaseStepListener baseStepListener = StepEventBus.getParallelEventBus().getBaseStepListener();
        byte[] screenshot = currentPage.screenshot(new Page.ScreenshotOptions().setFullPage(true));
        try {
            Path outputDirectory = baseStepListener.getOutputDirectory().toPath();
            Path screenshotFile = Files.createTempFile(outputDirectory, "screenshot", ".png", new FileAttribute[0]);
            Files.write(screenshotFile, screenshot, new OpenOption[0]);
            return screenshotFile.toFile();
        }
        catch (IOException e) {
            Assertions.fail((String)"Failed to take Playwright screenshot", (Throwable)e);
            return null;
        }
    }
}

