/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.playwright;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.microsoft.playwright.options.Proxy;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.thucydides.model.util.EnvironmentVariables;

public enum PlayWrightConfigurationProperties {
    BROWSER_TYPE("playwright.browsertype"),
    ARGS("playwright.args"),
    BROWSER_CHANNEL("playwright.channel"),
    CHROMIUM_SANDBOX("playwright.chromiumSandbox"),
    DEVTOOLS("playwright.devtools"),
    DOWNLOADS_PATH("playwright.downloadsPath"),
    ENV("playwright.env"),
    EXECUTABLE_PATH("playwright.executablePath"),
    HANDLE_SIGHUP("playwright.handleSIGHUP"),
    HANDLE_SIGINT("playwright.handleSIGINT"),
    HANDLE_SIGTERM("playwright.handleSIGTERM"),
    HEADLESS("playwright.headless"),
    TRACING("playwright.tracing"),
    IGNORE_ALL_DEFAULT_APPS("playwright.ignoreAllDefaultArgs"),
    IGNORE_DEFAULT_APPS("playwright.ignoreDefaultArgs"),
    SLOW_MO("playwright.slowMo"),
    TIMEOUT("playwright.timeout"),
    PROXY("playwright.proxy"),
    PROXY_SERVER("playwright.proxy.server"),
    PROXY_BYPASS("playwright.proxy.bypass"),
    PROXY_USERNAME("playwright.proxy.username"),
    PROXY_PASSWORD("playwright.proxy.password");

    private final String property;

    private PlayWrightConfigurationProperties(String property) {
        this.property = property;
    }

    public Optional<String> asStringFrom(EnvironmentVariables environmentVariables) {
        return environmentVariables.optionalProperty(this.property);
    }

    public Optional<Boolean> asBooleanFrom(EnvironmentVariables environmentVariables) {
        return environmentVariables.optionalProperty(this.property).map(Boolean::valueOf);
    }

    public Optional<Double> asDoubleFrom(EnvironmentVariables environmentVariables) {
        return environmentVariables.optionalProperty(this.property).map(Double::valueOf);
    }

    public Optional<Path> asPathFrom(EnvironmentVariables environmentVariables) {
        return environmentVariables.optionalProperty(this.property).map(x$0 -> Paths.get(x$0, new String[0]));
    }

    public Optional<Proxy> asProxyFrom(EnvironmentVariables environmentVariables) {
        if (environmentVariables.optionalProperty(PlayWrightConfigurationProperties.PROXY_SERVER.property).isPresent()) {
            String server = environmentVariables.getProperty(PlayWrightConfigurationProperties.PROXY_SERVER.property);
            Proxy proxy = new Proxy(server);
            environmentVariables.optionalProperty(PlayWrightConfigurationProperties.PROXY_USERNAME.property).ifPresent(arg_0 -> ((Proxy)proxy).setUsername(arg_0));
            environmentVariables.optionalProperty(PlayWrightConfigurationProperties.PROXY_PASSWORD.property).ifPresent(arg_0 -> ((Proxy)proxy).setPassword(arg_0));
            environmentVariables.optionalProperty(PlayWrightConfigurationProperties.PROXY_BYPASS.property).ifPresent(arg_0 -> ((Proxy)proxy).setBypass(arg_0));
            return Optional.of(proxy);
        }
        return Optional.empty();
    }

    public Optional<List<String>> asListOfStringsFrom(EnvironmentVariables environmentVariables) {
        if (environmentVariables.optionalProperty(this.property).isPresent()) {
            return Optional.of(Arrays.stream(environmentVariables.getProperty(this.property).split(",")).map(String::trim).collect(Collectors.toList()));
        }
        return Optional.empty();
    }

    public Optional<Map<String, String>> asJsonMapFrom(EnvironmentVariables environmentVariables) {
        if (environmentVariables.optionalProperty(this.property).isPresent()) {
            Gson gson = new Gson();
            Type mapOfStringsType = new TypeToken<Map<String, String>>(){}.getType();
            return Optional.of((Map)gson.fromJson(environmentVariables.getProperty(this.property), mapOfStringsType));
        }
        return Optional.empty();
    }
}

