/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.playwright.abilities;

import com.google.common.eventbus.Subscribe;
import com.microsoft.playwright.Browser;
import com.microsoft.playwright.BrowserContext;
import com.microsoft.playwright.BrowserType;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.Playwright;
import com.microsoft.playwright.Tracing;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.serenitybdd.core.eventbus.Broadcaster;
import net.serenitybdd.model.environment.ConfiguredEnvironment;
import net.serenitybdd.screenplay.Ability;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.RefersToActor;
import net.serenitybdd.screenplay.events.ActorAsksQuestion;
import net.serenitybdd.screenplay.events.ActorBeginsPerformanceEvent;
import net.serenitybdd.screenplay.events.ActorEndsPerformanceEvent;
import net.serenitybdd.screenplay.events.ActorPerformanceEvent;
import net.serenitybdd.screenplay.events.ActorPerforms;
import net.serenitybdd.screenplay.playwright.Photographer;
import net.serenitybdd.screenplay.playwright.PlayWrightConfigurationProperties;
import net.serenitybdd.screenplay.playwright.abilities.ActorCannotUsePlaywrightException;
import net.serenitybdd.screenplay.playwright.abilities.InvalidPlaywrightBrowserType;
import net.thucydides.core.events.TestLifecycleEvents;
import net.thucydides.core.model.screenshots.ScreenshotPermission;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.webdriver.capabilities.RemoteTestName;
import net.thucydides.model.domain.TakeScreenshots;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.screenshots.ScreenshotAndHtmlSource;
import net.thucydides.model.util.EnvironmentVariables;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowseTheWebWithPlaywright
implements Ability,
RefersToActor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrowseTheWebWithPlaywright.class);
    private Actor actor;
    private Photographer photographer;
    Playwright playwright;
    BrowserType.LaunchOptions launchOptions;
    Browser.NewContextOptions contextOptions;
    private static final String TRACES_PATH = "target/playwright/traces";
    boolean tracingEnabled;
    String traceName;
    private final Optional<String> browserType;
    private static final String DEFAULT_BROWSER_TYPE = "chromium";
    private Browser browser;
    private BrowserContext currentContext;
    private Page currentPage;
    private final EnvironmentVariables environmentVariables;
    private static final Map<String, Function<Playwright, BrowserType>> OPEN_BROWSER = new HashMap<String, Function<Playwright, BrowserType>>();

    protected BrowseTheWebWithPlaywright(EnvironmentVariables environmentVariables) {
        this(environmentVariables, new BrowserType.LaunchOptions(), PlayWrightConfigurationProperties.BROWSER_TYPE.asStringFrom(environmentVariables).orElse(null));
    }

    protected BrowseTheWebWithPlaywright(EnvironmentVariables environmentVariables, BrowserType.LaunchOptions launchOptions) {
        this(environmentVariables, launchOptions, PlayWrightConfigurationProperties.BROWSER_TYPE.asStringFrom(environmentVariables).orElse(null));
    }

    protected BrowseTheWebWithPlaywright(EnvironmentVariables environmentVariables, BrowserType.LaunchOptions launchOptions, String browserType) {
        this(environmentVariables, launchOptions, null, browserType);
    }

    protected BrowseTheWebWithPlaywright(EnvironmentVariables environmentVariables, BrowserType.LaunchOptions launchOptions, Browser.NewContextOptions contextOptions, String browserType) {
        this.environmentVariables = environmentVariables;
        this.launchOptions = launchOptions;
        this.contextOptions = contextOptions;
        this.browserType = Optional.ofNullable(browserType);
        this.registerForEventNotification();
    }

    private void registerForEventNotification() {
        Broadcaster.getEventBus().register((Object)this);
        TestLifecycleEvents.register((Object)this);
    }

    public static BrowseTheWebWithPlaywright as(Actor actor) {
        if (actor.abilityTo(BrowseTheWebWithPlaywright.class) == null) {
            throw new ActorCannotUsePlaywrightException(actor.getName());
        }
        return (BrowseTheWebWithPlaywright)((BrowseTheWebWithPlaywright)actor.abilityTo(BrowseTheWebWithPlaywright.class)).asActor(actor);
    }

    public Browser getBrowser() {
        if (this.browser == null) {
            this.browser = this.initialiseBrowser();
        }
        return this.browser;
    }

    private BrowserContext getCurrentContext() {
        if (this.currentContext == null) {
            this.currentContext = this.getBrowser().newContext(this.contextOptions);
        }
        return this.currentContext;
    }

    public Page getCurrentPage() {
        if (this.currentPage == null) {
            this.tracingEnabled = PlayWrightConfigurationProperties.TRACING.asBooleanFrom(this.environmentVariables).orElse(false);
            if (this.tracingEnabled) {
                Tracing.StartOptions tracingOptions = new Tracing.StartOptions().setScreenshots(true).setSnapshots(true);
                Optional latestOutcome = StepEventBus.getParallelEventBus().getBaseStepListener().latestTestOutcome();
                Optional guessedTestName = latestOutcome.map(testOutcome -> Optional.of(testOutcome.getStoryTitle() + ": " + testOutcome.getTitle())).orElseGet(RemoteTestName::fromCurrentTest);
                guessedTestName.ifPresent(name -> {
                    this.traceName = name;
                    tracingOptions.setName(name);
                    tracingOptions.setTitle(name);
                });
                this.getCurrentContext().tracing().start(tracingOptions);
            }
            this.currentPage = this.getCurrentContext().newPage();
        }
        return this.currentPage;
    }

    private Browser initialiseBrowser() {
        if (this.playwright == null) {
            this.playwright = Playwright.create();
        }
        BrowserType.LaunchOptions options = this.launchOptionsDefinedIn(this.environmentVariables);
        if (!OPEN_BROWSER.containsKey(this.configuredBrowser())) {
            throw new InvalidPlaywrightBrowserType(this.configuredBrowser());
        }
        return OPEN_BROWSER.get(this.configuredBrowser()).apply(this.playwright).launch(options);
    }

    private String configuredBrowser() {
        return this.browserType.orElse(DEFAULT_BROWSER_TYPE);
    }

    private BrowserType.LaunchOptions launchOptionsDefinedIn(EnvironmentVariables environmentVariables) {
        block20: {
            block19: {
                if (this.launchOptions.args == null) {
                    PlayWrightConfigurationProperties.ARGS.asListOfStringsFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.launchOptions).setArgs(arg_0));
                }
                if (this.launchOptions.channel == null) {
                    PlayWrightConfigurationProperties.BROWSER_CHANNEL.asStringFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.launchOptions).setChannel(arg_0));
                }
                if (this.launchOptions.chromiumSandbox == null) {
                    PlayWrightConfigurationProperties.CHROMIUM_SANDBOX.asBooleanFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.launchOptions).setChromiumSandbox(arg_0));
                }
                if (this.launchOptions.devtools == null) {
                    PlayWrightConfigurationProperties.DEVTOOLS.asBooleanFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.launchOptions).setChromiumSandbox(arg_0));
                }
                if (this.launchOptions.downloadsPath == null) {
                    PlayWrightConfigurationProperties.DOWNLOADS_PATH.asPathFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.launchOptions).setDownloadsPath(arg_0));
                }
                if (this.launchOptions.env == null) {
                    PlayWrightConfigurationProperties.ENV.asJsonMapFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.launchOptions).setEnv(arg_0));
                }
                if (this.launchOptions.executablePath == null) {
                    PlayWrightConfigurationProperties.EXECUTABLE_PATH.asPathFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.launchOptions).setExecutablePath(arg_0));
                }
                if (this.launchOptions.handleSIGHUP == null) {
                    PlayWrightConfigurationProperties.HANDLE_SIGHUP.asBooleanFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.launchOptions).setHandleSIGHUP(arg_0));
                }
                if (this.launchOptions.handleSIGINT == null) {
                    PlayWrightConfigurationProperties.HANDLE_SIGINT.asBooleanFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.launchOptions).setHandleSIGINT(arg_0));
                }
                if (this.launchOptions.handleSIGTERM == null) {
                    PlayWrightConfigurationProperties.HANDLE_SIGTERM.asBooleanFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.launchOptions).setHandleSIGTERM(arg_0));
                }
                if (this.launchOptions.headless == null) break block19;
                if (this.launchOptions.headless.booleanValue()) break block20;
            }
            PlayWrightConfigurationProperties.HEADLESS.asBooleanFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.launchOptions).setHeadless(arg_0));
        }
        if (this.launchOptions.ignoreAllDefaultArgs == null) {
            PlayWrightConfigurationProperties.IGNORE_ALL_DEFAULT_APPS.asBooleanFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.launchOptions).setIgnoreAllDefaultArgs(arg_0));
        }
        if (this.launchOptions.ignoreDefaultArgs == null) {
            PlayWrightConfigurationProperties.IGNORE_DEFAULT_APPS.asListOfStringsFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.launchOptions).setIgnoreDefaultArgs(arg_0));
        }
        if (this.launchOptions.proxy == null) {
            PlayWrightConfigurationProperties.PROXY.asProxyFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.launchOptions).setProxy(arg_0));
        }
        if (this.launchOptions.slowMo == null) {
            PlayWrightConfigurationProperties.SLOW_MO.asDoubleFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.launchOptions).setSlowMo(arg_0));
        }
        if (this.launchOptions.timeout == null) {
            PlayWrightConfigurationProperties.TIMEOUT.asDoubleFrom(environmentVariables).ifPresent(arg_0 -> ((BrowserType.LaunchOptions)this.launchOptions).setTimeout(arg_0));
        }
        if (this.launchOptions.tracesDir == null && PlayWrightConfigurationProperties.TRACING.asBooleanFrom(environmentVariables).isPresent()) {
            this.launchOptions.setTracesDir(Paths.get(TRACES_PATH, new String[0]));
        }
        return this.launchOptions;
    }

    public Photographer getPhotographer() {
        if (this.photographer == null) {
            this.photographer = new Photographer();
        }
        return this.photographer;
    }

    public ScreenshotAndHtmlSource takeScreenShot() {
        BaseStepListener baseStepListener = StepEventBus.getParallelEventBus().getBaseStepListener();
        Page currentPage = this.getCurrentPage();
        try {
            Path outputDirectory = baseStepListener.getOutputDirectory().toPath();
            Path pageSourceFile = Files.createTempFile(outputDirectory, "pagesource", ".txt", new FileAttribute[0]);
            Files.write(pageSourceFile, currentPage.content().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            File screenshot = this.getPhotographer().takesAScreenshot(currentPage);
            return new ScreenshotAndHtmlSource(screenshot, pageSourceFile.toFile());
        }
        catch (IOException e) {
            Assertions.fail((String)"Failed to take Playwright screenshot", (Throwable)e);
            return null;
        }
    }

    public void notifyScreenChange() {
        BaseStepListener baseStepListener = StepEventBus.getParallelEventBus().getBaseStepListener();
        ScreenshotPermission screenshots = new ScreenshotPermission(ConfiguredEnvironment.getConfiguration());
        if (screenshots.areAllowed(TakeScreenshots.FOR_EACH_ACTION)) {
            ScreenshotAndHtmlSource screenshotAndHtmlSource = this.takeScreenShot();
            baseStepListener.getCurrentTestOutcome().currentStep().ifPresent(step -> step.addScreenshot(screenshotAndHtmlSource));
        }
    }

    public <T extends Ability> T asActor(Actor actor) {
        this.actor = actor;
        return (T)this;
    }

    @Subscribe
    public void beginPerformance(ActorBeginsPerformanceEvent performanceEvent) {
        if (this.messageIsForThisActor((ActorPerformanceEvent)performanceEvent)) {
            LOGGER.debug("BEGIN " + String.valueOf(performanceEvent.getClass()));
        }
    }

    @Subscribe
    public void endPerformance(ActorEndsPerformanceEvent performanceEvent) {
        if (this.messageIsForThisActor((ActorPerformanceEvent)performanceEvent)) {
            LOGGER.debug("END " + String.valueOf(performanceEvent.getClass()));
        }
    }

    @Subscribe
    public void perform(ActorPerforms performAction) {
        if (this.messageIsForThisActor((ActorPerformanceEvent)performAction)) {
            LOGGER.debug("Perform " + String.valueOf(performAction.getPerformable()));
        }
    }

    @Subscribe
    public void prepareQuestion(ActorAsksQuestion questionEvent) {
        if (this.messageIsForThisActor((ActorPerformanceEvent)questionEvent)) {
            LOGGER.debug("Question " + String.valueOf(questionEvent.getQuestion()));
        }
    }

    @Subscribe
    public void testFinishes(TestLifecycleEvents.TestFinished testFinished) {
        if (this.currentContext != null && this.tracingEnabled) {
            this.currentContext.tracing().stop(new Tracing.StopOptions().setPath(Paths.get(String.format("%s/%s.zip", TRACES_PATH, this.traceName), new String[0])));
        }
        if (this.playwright != null) {
            BaseStepListener baseStepListener = StepEventBus.getParallelEventBus().getBaseStepListener();
            ScreenshotPermission screenshots = new ScreenshotPermission(ConfiguredEnvironment.getConfiguration());
            if (baseStepListener.currentTestFailed() && screenshots.areAllowed(TakeScreenshots.FOR_FAILURES)) {
                ScreenshotAndHtmlSource screenshotAndHtmlSource = this.takeScreenShot();
                baseStepListener.firstFailingStep().ifPresent(step -> step.addScreenshot(screenshotAndHtmlSource));
            }
            this.playwright.close();
            this.currentPage = null;
            this.currentContext = null;
            this.playwright = null;
        }
    }

    private boolean messageIsForThisActor(ActorPerformanceEvent event) {
        return this.actor != null && event.getName().equals(this.actor.getName());
    }

    public static BrowseTheWebWithPlaywright usingTheDefaultConfiguration() {
        return new BrowseTheWebWithPlaywright(SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    public static BrowseTheWebWithPlaywright withOptions(BrowserType.LaunchOptions options) {
        return new BrowseTheWebWithPlaywright(SystemEnvironmentVariables.currentEnvironmentVariables(), options);
    }

    public BrowseTheWebWithPlaywright withContextOptions(Browser.NewContextOptions contextOptions) {
        return new BrowseTheWebWithPlaywright(SystemEnvironmentVariables.currentEnvironmentVariables(), this.launchOptions, contextOptions, this.browserType.orElse(null));
    }

    public BrowseTheWebWithPlaywright withBrowserType(String browserType) {
        return new BrowseTheWebWithPlaywright(this.environmentVariables, this.launchOptions, browserType);
    }

    public BrowseTheWebWithPlaywright withHeadlessMode(Boolean headless) {
        return new BrowseTheWebWithPlaywright(this.environmentVariables, this.launchOptions.setHeadless(headless.booleanValue()), this.browserType.orElse(null));
    }

    static {
        OPEN_BROWSER.put(DEFAULT_BROWSER_TYPE, Playwright::chromium);
        OPEN_BROWSER.put("webkit", Playwright::webkit);
        OPEN_BROWSER.put("firefox", Playwright::firefox);
    }
}

