/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.playwright.assertions;

import com.microsoft.playwright.Page;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.Task;
import net.serenitybdd.screenplay.playwright.Target;
import net.serenitybdd.screenplay.playwright.abilities.BrowseTheWebWithPlaywright;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;

public class Ensure {
    private Target target;
    private Double timeout;

    public Ensure(Target target, Double timeout) {
        this.target = target;
        this.timeout = timeout;
    }

    public static Ensure that(String selector) {
        return new Ensure(Target.the(selector).locatedBy(selector), null);
    }

    public static Ensure that(Target target) {
        return new Ensure(target, null);
    }

    public Ensure withTimeout(Double timeout) {
        return new Ensure(this.target, timeout);
    }

    private boolean timeoutIsSpecified() {
        return this.timeout != null;
    }

    public Performable isVisible() {
        return Task.where((String)(String.valueOf(this.target) + " should be visible"), actor -> {
            boolean elementIsVisible;
            if (this.timeoutIsSpecified()) {
                Page.IsVisibleOptions options = new Page.IsVisibleOptions().setTimeout(this.timeout.doubleValue());
                elementIsVisible = BrowseTheWebWithPlaywright.as(actor).getCurrentPage().isVisible(this.target.asSelector(), options);
            } else {
                elementIsVisible = BrowseTheWebWithPlaywright.as(actor).getCurrentPage().isVisible(this.target.asSelector());
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)elementIsVisible).withFailMessage("Expecting <%s> to be visible", new Object[]{this.target})).isTrue();
        });
    }

    public Performable isHidden() {
        return Task.where((String)(String.valueOf(this.target) + " should be hidden"), actor -> {
            boolean elementIsHidden;
            if (this.timeoutIsSpecified()) {
                Page.IsHiddenOptions options = new Page.IsHiddenOptions().setTimeout(this.timeout.doubleValue());
                elementIsHidden = BrowseTheWebWithPlaywright.as(actor).getCurrentPage().isHidden(this.target.asSelector(), options);
            } else {
                elementIsHidden = BrowseTheWebWithPlaywright.as(actor).getCurrentPage().isHidden(this.target.asSelector());
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)elementIsHidden).withFailMessage("Expecting <%s> to be hidden", new Object[]{this.target})).isTrue();
        });
    }

    public Performable currentValue(String expectedValue) {
        return Task.where((String)(String.valueOf(this.target) + " should have value " + expectedValue), actor -> {
            String currentValue;
            Page currentPage = BrowseTheWebWithPlaywright.as(actor).getCurrentPage();
            if (this.timeoutIsSpecified()) {
                Page.InputValueOptions options = new Page.InputValueOptions().setTimeout(this.timeout.doubleValue());
                currentValue = currentPage.inputValue(this.target.asSelector(), options);
            } else {
                currentValue = currentPage.inputValue(this.target.asSelector());
            }
            ((AbstractStringAssert)Assertions.assertThat((String)currentValue).describedAs("Expecting <%s> to have different value", new Object[]{this.target})).isEqualTo(expectedValue);
        });
    }

    public Performable isChecked() {
        return Task.where((String)(String.valueOf(this.target) + " should be checked"), actor -> {
            boolean elementIsChecked;
            if (this.timeoutIsSpecified()) {
                Page.IsCheckedOptions options = new Page.IsCheckedOptions().setTimeout(this.timeout.doubleValue());
                elementIsChecked = BrowseTheWebWithPlaywright.as(actor).getCurrentPage().isChecked(this.target.asSelector(), options);
            } else {
                elementIsChecked = BrowseTheWebWithPlaywright.as(actor).getCurrentPage().isChecked(this.target.asSelector());
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)elementIsChecked).withFailMessage("Expecting <%s> to be checked", new Object[]{this.target})).isTrue();
        });
    }

    public Performable isNotChecked() {
        return Task.where((String)(String.valueOf(this.target) + " should not be checked"), actor -> {
            boolean elementIsChecked;
            if (this.timeoutIsSpecified()) {
                Page.IsCheckedOptions options = new Page.IsCheckedOptions().setTimeout(this.timeout.doubleValue());
                elementIsChecked = BrowseTheWebWithPlaywright.as(actor).getCurrentPage().isChecked(this.target.asSelector(), options);
            } else {
                elementIsChecked = BrowseTheWebWithPlaywright.as(actor).getCurrentPage().isChecked(this.target.asSelector());
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)elementIsChecked).withFailMessage("Expecting <%s> to be unchecked", new Object[]{this.target})).isFalse();
        });
    }

    public Performable isEnabled() {
        return Task.where((String)(String.valueOf(this.target) + " should be enabled"), actor -> {
            boolean elementIsEnabled;
            if (this.timeoutIsSpecified()) {
                Page.IsEnabledOptions options = new Page.IsEnabledOptions().setTimeout(this.timeout.doubleValue());
                elementIsEnabled = BrowseTheWebWithPlaywright.as(actor).getCurrentPage().isEnabled(this.target.asSelector(), options);
            } else {
                elementIsEnabled = BrowseTheWebWithPlaywright.as(actor).getCurrentPage().isEnabled(this.target.asSelector());
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)elementIsEnabled).withFailMessage("Expecting <%s> to be enabled", new Object[]{this.target})).isTrue();
        });
    }

    public Performable isDisabled() {
        return Task.where((String)(String.valueOf(this.target) + " should be disabled"), actor -> {
            boolean elementIsDisabled;
            if (this.timeoutIsSpecified()) {
                Page.IsDisabledOptions options = new Page.IsDisabledOptions().setTimeout(this.timeout.doubleValue());
                elementIsDisabled = BrowseTheWebWithPlaywright.as(actor).getCurrentPage().isDisabled(this.target.asSelector(), options);
            } else {
                elementIsDisabled = BrowseTheWebWithPlaywright.as(actor).getCurrentPage().isDisabled(this.target.asSelector());
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)elementIsDisabled).withFailMessage("Expecting <%s> to be disabled", new Object[]{this.target})).isTrue();
        });
    }

    public Performable isEditable() {
        return Task.where((String)(String.valueOf(this.target) + " should be editable"), actor -> {
            boolean elementIsEditable;
            if (this.timeoutIsSpecified()) {
                Page.IsEditableOptions options = new Page.IsEditableOptions().setTimeout(this.timeout.doubleValue());
                elementIsEditable = BrowseTheWebWithPlaywright.as(actor).getCurrentPage().isEditable(this.target.asSelector(), options);
            } else {
                elementIsEditable = BrowseTheWebWithPlaywright.as(actor).getCurrentPage().isEditable(this.target.asSelector());
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)elementIsEditable).withFailMessage("Expecting <%s> to be editable", new Object[]{this.target})).isTrue();
        });
    }
}

