/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.playwright.interactions;

import java.nio.file.Paths;
import net.serenitybdd.annotations.Step;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.playwright.Target;
import net.serenitybdd.screenplay.playwright.abilities.BrowseTheWebWithPlaywright;
import net.serenitybdd.screenplay.playwright.interactions.Click;

public class Upload
implements Performable {
    private String path;
    private Target target;

    public Upload(String path) {
        this.path = path;
    }

    public static Upload file(String path) {
        return new Upload(path);
    }

    public Performable to(String selector) {
        this.target = Target.the(selector).locatedBy(selector);
        return this;
    }

    public Performable to(Target target) {
        this.target = target;
        return this;
    }

    @Step(value="{0} uploads file from #path to #target")
    public <T extends Actor> void performAs(T actor) {
        BrowseTheWebWithPlaywright.as(actor).getCurrentPage().onFileChooser(fileChooser -> fileChooser.setFiles(Paths.get(this.path, new String[0])));
        actor.attemptsTo(new Performable[]{Click.on(this.target)});
        BrowseTheWebWithPlaywright.as(actor).notifyScreenChange();
    }
}

