/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.rest.abiities;

import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import java.util.function.Function;
import net.serenitybdd.rest.SerenityRest;
import net.serenitybdd.screenplay.Ability;
import net.serenitybdd.screenplay.Actor;

public class CallAnApi
implements Ability {
    private final String baseURL;
    private Response lastResponse;
    Function<RequestSpecification, RequestSpecification> config = request -> request.header("Content-Type", (Object)"application/json", new Object[0]).body("{\"name\": \"joe\",\"job\": \"leader\"}");

    private CallAnApi(String baseURL) {
        this.baseURL = baseURL;
    }

    public static CallAnApi at(String baseURL) {
        return new CallAnApi(baseURL);
    }

    public static CallAnApi as(Actor actor) {
        return (CallAnApi)actor.abilityTo(CallAnApi.class);
    }

    public void get(String resource) {
        this.lastResponse = (Response)SerenityRest.given().get(this.baseURL + resource, new Object[0]);
    }

    public String resolve(String resource) {
        return this.baseURL + resource;
    }

    public void post(String resource) {
        RequestSpecification s = this.config.apply(SerenityRest.given());
        s.post(this.baseURL + resource, new Object[0]);
    }

    public Response getLastResponse() {
        return SerenityRest.lastResponse();
    }

    public RequestSpecification withRestAssured() {
        return SerenityRest.rest();
    }
}

