/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.rest.interactions;

import io.restassured.specification.RequestSpecification;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.serenitybdd.rest.SerenityRest;
import net.serenitybdd.screenplay.Interaction;
import net.serenitybdd.screenplay.rest.questions.RestQueryFunction;

public abstract class RestInteraction
implements Interaction {
    List<Function<RequestSpecification, RequestSpecification>> restConfigurations = new ArrayList<Function<RequestSpecification, RequestSpecification>>();

    public RestInteraction with(RestQueryFunction restConfiguration) {
        this.restConfigurations.add(restConfiguration);
        return this;
    }

    public RestInteraction with(List<RestQueryFunction> restConfigurations) {
        this.restConfigurations.addAll(restConfigurations);
        return this;
    }

    protected RequestSpecification rest() {
        RequestSpecification requestSpecification = SerenityRest.given();
        for (Function<RequestSpecification, RequestSpecification> restConfiguration : this.restConfigurations) {
            requestSpecification = restConfiguration.apply(requestSpecification);
        }
        return requestSpecification;
    }
}

