/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.targets;

import java.util.List;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.abilities.BrowseTheWeb;
import net.serenitybdd.screenplay.targets.EnsureFieldVisible;
import net.serenitybdd.screenplay.targets.Target;
import net.serenitybdd.screenplay.targets.TargetResolver;
import net.serenitybdd.screenplay.targets.TargetSelectorWithVariables;

public class XPathOrCssTarget
extends Target {
    private final String cssOrXPathSelector;

    public XPathOrCssTarget(String targetElementName, String cssOrXPathSelector) {
        super(targetElementName);
        this.cssOrXPathSelector = cssOrXPathSelector;
    }

    @Override
    public WebElementFacade resolveFor(Actor theActor) {
        TargetResolver resolver = new TargetResolver(BrowseTheWeb.as(theActor).getDriver());
        WebElementFacade resolvedTarget = resolver.findBy(this.cssOrXPathSelector);
        EnsureFieldVisible.ensureThat(theActor).canSee(resolvedTarget);
        return resolvedTarget;
    }

    @Override
    public List<WebElementFacade> resolveAllFor(Actor actor) {
        TargetResolver resolver = new TargetResolver(BrowseTheWeb.as(actor).getDriver());
        return resolver.findAll(this.cssOrXPathSelector);
    }

    @Override
    public Target of(String ... parameters) {
        return new XPathOrCssTarget(this.targetElementName, this.instantiated(this.cssOrXPathSelector, parameters));
    }

    @Override
    public Target called(String name) {
        return new XPathOrCssTarget(name, this.cssOrXPathSelector);
    }

    @Override
    public String getCssOrXPathSelector() {
        return this.cssOrXPathSelector;
    }

    private String instantiated(String cssOrXPathSelector, String[] parameters) {
        return new TargetSelectorWithVariables(cssOrXPathSelector).resolvedWith(parameters);
    }
}

