/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.questions;

import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.questions.UIState;
import net.serenitybdd.screenplay.targets.Target;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIStateReaderWithNameBuilder<T> {
    protected final Target target;
    protected final Class<T> type;

    public UIStateReaderWithNameBuilder(Target target, Class<T> type) {
        this.target = target;
        this.type = type;
    }

    public PrimedUIStateReaderWithNameBuilder<T> named(String name) {
        return new PrimedUIStateReaderWithNameBuilder<T>(this.target, this.type, name);
    }

    public static class PrimedUIStateReaderWithNameBuilder<T>
    extends UIStateReaderWithNameBuilder<T> {
        private final String name;
        private Logger logger = LoggerFactory.getLogger(this.getClass());

        public PrimedUIStateReaderWithNameBuilder(Target target, Class<T> type, String name) {
            super(target, type);
            this.name = name;
        }

        public <T extends UIState> T viewedBy(Actor actor) {
            try {
                return (T)((UIState)this.type.getConstructor(Target.class, Actor.class, String.class).newInstance(this.target, actor, this.name));
            }
            catch (Exception e) {
                this.logger.error("Failed to instantiate UIStateReader of type " + this.type, (Throwable)e);
                throw new IllegalStateException("Failed to instantiate UIStateReader of type " + this.type, e);
            }
        }
    }
}

