/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.questions;

import java.util.List;
import java.util.Set;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.core.pages.WebElementState;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Question;
import net.serenitybdd.screenplay.annotations.Subject;
import net.serenitybdd.screenplay.matchers.statematchers.CheckForAbsenceHint;
import net.serenitybdd.screenplay.matchers.statematchers.MissingWebElement;
import net.serenitybdd.screenplay.questions.AcceptsHints;
import net.serenitybdd.screenplay.questions.QuestionHint;
import net.serenitybdd.screenplay.questions.UnresolvedTargetWebElementState;
import net.serenitybdd.screenplay.targets.Target;
import org.openqa.selenium.NoSuchElementException;

@Subject(value="#target")
public class WebElementQuestion
implements Question<WebElementState>,
AcceptsHints {
    private final Target target;
    private boolean checkForAbsence = false;

    public WebElementQuestion(Target target) {
        this.target = target;
    }

    public static Question<WebElementState> stateOf(Target target) {
        return new WebElementQuestion(target);
    }

    public static Question<WebElementState> valueOf(Target target) {
        return WebElementQuestion.stateOf(target);
    }

    public static Question<WebElementState> the(Target target) {
        return WebElementQuestion.stateOf(target);
    }

    public WebElementState answeredBy(Actor actor) {
        return this.checkForAbsence ? this.checkForAbsenceBy(actor) : this.checkForPresenceBy(actor);
    }

    private WebElementState checkForAbsenceBy(Actor actor) {
        List<WebElementFacade> matchingElements = this.target.resolveAllFor(actor);
        if (matchingElements.isEmpty()) {
            return new MissingWebElement(this.target.getName());
        }
        return (WebElementState)matchingElements.get(0);
    }

    private WebElementState checkForPresenceBy(Actor actor) {
        try {
            return this.target.resolveFor(actor);
        }
        catch (NoSuchElementException unresolvedTarget) {
            return new UnresolvedTargetWebElementState(this.target.getName());
        }
    }

    public void apply(Set<Class<? extends QuestionHint>> hints) {
        this.checkForAbsence = hints.contains(CheckForAbsenceHint.class);
    }
}

