/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.targets;

import java.util.Optional;
import net.serenitybdd.screenplay.targets.ByTarget;
import net.serenitybdd.screenplay.targets.IFrame;
import net.serenitybdd.screenplay.targets.Target;
import net.serenitybdd.screenplay.targets.XPathOrCssTarget;
import org.openqa.selenium.By;

public class TargetBuilder<T> {
    private String targetElementName;
    private Optional<IFrame> iFrame = Optional.empty();

    public TargetBuilder(String targetElementName) {
        this.targetElementName = targetElementName;
    }

    public TargetBuilder inIFrame(IFrame iFrame) {
        this.iFrame = Optional.ofNullable(iFrame);
        return this;
    }

    public Target locatedBy(String cssOrXPathSelector) {
        return new XPathOrCssTarget(this.targetElementName, cssOrXPathSelector, this.iFrame);
    }

    public Target located(By locator) {
        return new ByTarget(this.targetElementName, locator, this.iFrame);
    }
}

