/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.targets;

import java.util.Optional;
import net.serenitybdd.screenplay.targets.ByTarget;
import net.serenitybdd.screenplay.targets.IFrame;
import net.serenitybdd.screenplay.targets.LocatesCrossPlatform;
import net.serenitybdd.screenplay.targets.Target;
import net.serenitybdd.screenplay.targets.XPathOrCssTarget;
import org.openqa.selenium.By;

public class TargetBuilder<T> {
    private String targetElementName;
    private Optional<IFrame> iFrame = Optional.empty();

    public TargetBuilder(String targetElementName) {
        this.targetElementName = targetElementName;
    }

    public TargetBuilder inIFrame(IFrame iFrame) {
        this.iFrame = Optional.ofNullable(iFrame);
        return this;
    }

    public Target locatedBy(String cssOrXPathSelector) {
        return new XPathOrCssTarget(this.targetElementName, cssOrXPathSelector, this.iFrame, Optional.empty());
    }

    public Target located(By locator) {
        return new ByTarget(this.targetElementName, locator, this.iFrame);
    }

    public LocatesCrossPlatform locatedForAndroid(By androidLocator) {
        return new CrossPlatformTargetBuilder(this.targetElementName, androidLocator, this.iFrame);
    }

    static class CrossPlatformTargetBuilder
    implements LocatesCrossPlatform {
        private String targetElementName;
        private By androidLocator;
        private Optional<IFrame> iFrame;

        CrossPlatformTargetBuilder(String targetElementName, By androidLocator, Optional<IFrame> iFrame) {
            this.targetElementName = targetElementName;
            this.androidLocator = androidLocator;
            this.iFrame = iFrame;
        }

        @Override
        public Target locatedForIOS(By iosLocator) {
            return new ByTarget(this.targetElementName, this.androidLocator, iosLocator, this.iFrame);
        }
    }
}

