/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.injectors;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.di.DependencyInjector;
import net.serenitybdd.screenplay.Ability;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.abilities.BrowseTheWeb;
import net.serenitybdd.screenplay.annotations.CastMember;
import net.serenitybdd.screenplay.injectors.CastingException;
import net.thucydides.core.annotations.Fields;
import net.thucydides.core.annotations.Managed;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.WebDriverFacade;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;

public class WebCapableActorInjector
implements DependencyInjector {
    public void injectDependenciesInto(Object object) {
        Fields.of(object.getClass()).fieldsAnnotatedBy(CastMember.class).forEach(field -> this.injectActor((Field)field, object));
    }

    private void injectActor(Field field, Object object) {
        CastMember castMember = field.getAnnotation(CastMember.class);
        String name = castMember.name();
        String description = castMember.description();
        if (name.isEmpty()) {
            name = StringUtils.capitalize((String)field.getName());
        }
        Actor actor = Actor.named((String)name).describedAs(description);
        try {
            this.browserFor(object, castMember).ifPresent(browser -> actor.can((Ability)BrowseTheWeb.with(browser)));
            field.setAccessible(true);
            field.set(object, actor);
        }
        catch (IllegalAccessException e) {
            throw new CastingException("Unable to instantiate actor " + name, e);
        }
    }

    private Optional<WebDriver> browserFor(Object object, CastMember castMember) throws IllegalAccessException {
        List browserFields = Fields.of(object.getClass()).fieldsAnnotatedBy(Managed.class);
        if (!castMember.withAssignedBrowser()) {
            return Optional.empty();
        }
        if (castMember.browserField().isEmpty()) {
            return Optional.of(this.driverFor(castMember));
        }
        Field matchingBrowserField = this.browserFieldCalled(browserFields, castMember.browserField(), object).orElseThrow(() -> new IllegalArgumentException("Could not instantiate the actor " + castMember.name() + ": the browserField attribute was specified but no @Managed field called '" + castMember.browserField() + "' was found in this class."));
        return Optional.of(this.driverInField(matchingBrowserField, object));
    }

    private WebDriver driverFor(CastMember castMember) {
        WebDriver driver = castMember.driver().isEmpty() ? ThucydidesWebDriverSupport.getWebdriverManager().getWebdriverByName(castMember.name()) : ThucydidesWebDriverSupport.getWebdriverManager().withOptions(castMember.options()).getWebdriverByName(castMember.name(), castMember.driver());
        if (driver instanceof WebDriverFacade) {
            ((WebDriverFacade)driver).reset();
        }
        return driver;
    }

    private Optional<Field> browserFieldCalled(List<Field> browserFields, String browserFieldName, Object object) {
        return browserFields.stream().filter(field -> field.getName().equals(browserFieldName)).findFirst();
    }

    private WebDriver driverInField(Field field, Object object) {
        try {
            field.setAccessible(true);
            return (WebDriver)field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new CastingException("Unable to instantiate actor with webdriver for field " + field.getName(), e);
        }
    }

    public void reset() {
    }
}

