/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.questions;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.core.pages.WebElementState;
import net.serenitybdd.screenplay.Question;
import net.serenitybdd.screenplay.abilities.BrowseTheWeb;
import net.serenitybdd.screenplay.questions.LabelledQuestion;
import net.serenitybdd.screenplay.targets.Target;
import org.openqa.selenium.By;

public class SelectedStatus {
    public static Question<Boolean> of(Target target) {
        return LabelledQuestion.answer(target.getName() + " is selected", (Question<Boolean>)((Question)actor -> SelectedStatus.matches(target.resolveAllFor(actor))));
    }

    public static Question<Boolean> of(By byLocator) {
        return LabelledQuestion.answer(byLocator + " is selected", (Question<Boolean>)((Question)actor -> SelectedStatus.matches((List<WebElementFacade>)BrowseTheWeb.as(actor).findAll(byLocator))));
    }

    public static Question<Boolean> of(String locator) {
        return LabelledQuestion.answer(locator + " is selected", (Question<Boolean>)((Question)actor -> SelectedStatus.matches((List<WebElementFacade>)BrowseTheWeb.as(actor).findAll(locator, new Object[0]))));
    }

    public static Question<List<Boolean>> ofEach(Target target) {
        return LabelledQuestion.answerEach(target.getName() + " are selected", (Question<List<Boolean>>)((Question)actor -> target.resolveAllFor(actor).stream().map(element -> SelectedStatus.matches(Collections.singletonList(element))).collect(Collectors.toList())));
    }

    public static Question<List<Boolean>> ofEach(By byLocator) {
        return LabelledQuestion.answerEach(byLocator + " are selected", (Question<List<Boolean>>)((Question)actor -> BrowseTheWeb.as(actor).findAll(byLocator).stream().map(element -> SelectedStatus.matches(Collections.singletonList(element))).collect(Collectors.toList())));
    }

    public static Question<List<Boolean>> ofEach(String locator) {
        return LabelledQuestion.answerEach(locator + " are selected", (Question<List<Boolean>>)((Question)actor -> BrowseTheWeb.as(actor).findAll(locator, new Object[0]).stream().map(element -> SelectedStatus.matches(Collections.singletonList(element))).collect(Collectors.toList())));
    }

    private static boolean matches(List<WebElementFacade> elements) {
        return elements.stream().findFirst().map(WebElementState::isSelected).orElse(false);
    }
}

