/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ui;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.serenitybdd.core.pages.PageObject;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.screenplay.targets.Target;
import net.serenitybdd.screenplay.ui.CSSAttributeValue;
import org.openqa.selenium.By;

public class LocatorStrategies {
    public static Function<PageObject, List<WebElementFacade>> fieldWithLabel(String labelText) {
        return onThePage -> {
            WebElementFacade label = onThePage.withTimeoutOf(Duration.ZERO).find("//label[normalize-space(.)='" + CSSAttributeValue.withEscapedQuotes(labelText) + "']");
            String fieldId = label.getAttribute("for");
            WebElementFacade field = onThePage.withTimeoutOf(Duration.ZERO).find(By.id((String)fieldId));
            return Collections.singletonList(field);
        };
    }

    public static Function<PageObject, List<WebElementFacade>> findNestedElements(Target container, Target nestedElement) {
        return page -> {
            WebElementFacade containerElement = container.resolveFor((PageObject)page);
            return containerElement.withTimeoutOf(Duration.ZERO).thenFindAll(nestedElement.selectors(page.getDriver()).toArray(new By[0]));
        };
    }
}

