/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ui;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.serenitybdd.core.pages.ListOfWebElementFacades;
import net.serenitybdd.core.pages.PageObject;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.screenplay.targets.Target;
import net.serenitybdd.screenplay.ui.CSSAttributeValue;
import org.openqa.selenium.By;

public class LocatorStrategies {
    public static Function<PageObject, List<WebElementFacade>> fieldWithLabel(String labelText) {
        return onThePage -> {
            ListOfWebElementFacades matchingLabelsWithForAttribute = onThePage.findAll(LocatorStrategies.labelsWithText(labelText), new Object[0]);
            if (matchingLabelsWithForAttribute.isEmpty()) {
                return new ArrayList();
            }
            String fieldId = ((WebElementFacade)matchingLabelsWithForAttribute.get(0)).getAttribute("for");
            if (fieldId == null || fieldId.isEmpty()) {
                return matchingLabelsWithForAttribute;
            }
            return onThePage.findAll(By.id((String)fieldId));
        };
    }

    public static Function<PageObject, List<WebElementFacade>> findNestedElements(Target container, Target nestedElement) {
        return page -> {
            WebElementFacade containerElement = container.resolveFor((PageObject)page);
            return containerElement.withTimeoutOf(Duration.ZERO).thenFindAll(nestedElement.selectors(page.getDriver()).toArray(new By[0]));
        };
    }

    private static String labelsWithText(String labelText) {
        return "//label[normalize-space(.)='" + CSSAttributeValue.withEscapedQuotes(labelText) + "']";
    }
}

