/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.targets;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.pages.ListOfWebElementFacades;
import net.serenitybdd.core.pages.PageObject;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.core.webdriver.RemoteDriver;
import net.serenitybdd.screenplay.targets.IFrame;
import net.serenitybdd.screenplay.targets.SearchableTarget;
import net.serenitybdd.screenplay.targets.Target;
import net.thucydides.core.webdriver.ThucydidesConfigurationException;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public class ByTarget
extends SearchableTarget {
    private By locator;
    private By androidLocator;
    private By iosLocator;

    public ByTarget(String targetElementName, By locator, Optional<IFrame> iFrame) {
        super(targetElementName, iFrame);
        this.locator = locator;
    }

    public ByTarget(String targetElementName, By androidLocator, By iosLocator, Optional<IFrame> iFrame) {
        super(targetElementName, iFrame);
        this.androidLocator = androidLocator;
        this.iosLocator = iosLocator;
    }

    public ByTarget(String targetElementName, By androidLocator, By iosLocator, Optional<IFrame> iFrame, Optional<Duration> timeout) {
        super(targetElementName, iFrame, timeout);
        this.androidLocator = androidLocator;
        this.iosLocator = iosLocator;
    }

    protected ByTarget(String targetElementName, By locator, By androidLocator, By iosLocator, Optional<IFrame> iFrame, Optional<Duration> timeout) {
        super(targetElementName, iFrame, timeout);
        this.locator = locator;
        this.androidLocator = androidLocator;
        this.iosLocator = iosLocator;
    }

    @Override
    public WebElementFacade resolveFor(PageObject page) {
        if (this.timeout.isPresent()) {
            return page.withTimeoutOf((Duration)this.timeout.get()).find(this.getLocatorForPlatform(page.getDriver()));
        }
        return page.find(this.getLocatorForPlatform(page.getDriver()));
    }

    @Override
    public ListOfWebElementFacades resolveAllFor(PageObject page) {
        if (this.timeout.isPresent()) {
            return new ListOfWebElementFacades((Collection)page.withTimeoutOf((Duration)this.timeout.get()).findAll(this.getLocatorForPlatform(page.getDriver())));
        }
        return new ListOfWebElementFacades((Collection)page.findAll(this.getLocatorForPlatform(page.getDriver())));
    }

    @Override
    public SearchableTarget of(String ... parameters) {
        throw new UnsupportedOperationException("The of() method is not supported for By-type Targets");
    }

    private By getLocatorForPlatform(WebDriver driver) {
        if (null != this.androidLocator && null != this.iosLocator) {
            String platform;
            try {
                platform = RemoteDriver.isStubbed((WebDriver)driver) ? "IOS" : RemoteDriver.of((WebDriver)driver).getCapabilities().getCapability("platformName").toString().toUpperCase();
            }
            catch (Exception e) {
                throw new ThucydidesConfigurationException(String.format("The configured driver '%s' does not support Cross Platform Mobile targets", driver), (Throwable)e);
            }
            if (platform.equals("ANDROID")) {
                return this.androidLocator;
            }
            if (platform.equals("IOS")) {
                return this.iosLocator;
            }
            throw new ThucydidesConfigurationException(String.format("'%s' is not a valid platform for Cross Platform Mobile targets", platform));
        }
        return this.locator;
    }

    @Override
    public String getCssOrXPathSelector() {
        throw new UnsupportedOperationException("The getCssOrXPathSelector() method is not supported for By-type Targets");
    }

    @Override
    public Target waitingForNoMoreThan(Duration timeout) {
        return new ByTarget(this.targetElementName, this.locator, this.androidLocator, this.iosLocator, this.iFrame, Optional.ofNullable(timeout));
    }

    @Override
    public List<By> selectors(WebDriver driver) {
        return Collections.singletonList(this.getLocatorForPlatform(driver));
    }

    @Override
    public ByTarget called(String name) {
        return new ByTarget(name, this.locator, this.androidLocator, this.iosLocator, this.iFrame, this.timeout);
    }

    @Override
    public List<String> getCssOrXPathSelectors() {
        throw new UnsupportedOperationException("The getCssOrXPathSelector() method is not supported for By Targets");
    }
}

