/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ui;

import net.serenitybdd.screenplay.targets.SearchableTarget;
import net.serenitybdd.screenplay.targets.Target;

public class Button {
    private static final String ARIA_LABEL = "input[type='button'][aria-label='{0}' i],input[type='submit'][aria-label='{0}' i],button[aria-label='{0}' i]";
    private static final String[] LOCATORS = new String[]{"xpath:.//button[translate(normalize-space(.),'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')=translate('{0}','ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')]", "css:input[type='submit'][value='{0}' i],input[type='submit'][id='{0}' i],input[type='submit'][data-test='{0}' i],input[type='submit'][name='{0}' i],input[type='button'][value='{0}' i],input[type='button'][id='{0}' i],input[type='button'][data-test='{0}' i],input[type='button'][name='{0}' i],input[type='button'][aria-label='{0}' i],input[type='submit'][aria-label='{0}' i],button[aria-label='{0}' i],input[class*='{0}' i]"};
    private static final String BY_ICON = ".//button[./i[contains(@class,'{0}')]]";

    public static SearchableTarget called(String name) {
        return Target.the("'" + name + "' button").locatedByFirstMatching(LOCATORS).of(name);
    }

    public static SearchableTarget withLabel(String name) {
        return Target.the("'" + name + "' button").locatedByFirstMatching("css:input[type='button'][aria-label='{0}' i],input[type='submit'][aria-label='{0}' i],button[aria-label='{0}' i]").of(name);
    }

    public static Target withIcon(String icon) {
        return Target.the("Button with icon '" + icon + "'").locatedByFirstMatching(BY_ICON).of(icon);
    }
}

