/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ui;

import net.serenitybdd.screenplay.targets.Target;
import net.serenitybdd.screenplay.ui.CSSAttributeValue;
import org.openqa.selenium.By;

public class Image {
    private static final String BY_ID_OR_NAME = "css:img[id='{0}' i],img[name='{0}' i],img[data-test='{0}' i],img[class*='{0}' i]";

    public static Target called(String name) {
        return Target.the("'the " + name + "' image").locatedBy(BY_ID_OR_NAME).of(name);
    }

    public static Target withAltText(String altText) {
        String altTextAttribute = CSSAttributeValue.withEscapedQuotes(altText);
        return Target.the("'" + altTextAttribute + "' image").located(By.cssSelector((String)("img[alt='" + altTextAttribute + "']")));
    }

    public static Target withSrc(String srcValue) {
        String srcAttribute = CSSAttributeValue.withEscapedQuotes(srcValue);
        return Target.the("'" + srcValue + "' image").located(By.cssSelector((String)("img[src='" + srcAttribute + "']")));
    }

    public static Target withSrcEndingWith(String srcValue) {
        String srcAttribute = CSSAttributeValue.withEscapedQuotes(srcValue);
        return Target.the("'" + srcValue + "' image").located(By.cssSelector((String)("img[src$='" + srcAttribute + "']")));
    }

    public static Target withSrcStartingWith(String srcValue) {
        String srcAttribute = CSSAttributeValue.withEscapedQuotes(srcValue);
        return Target.the("'" + srcValue + "' image").located(By.cssSelector((String)("img[src^='" + srcAttribute + "']")));
    }
}

