/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ui;

import net.serenitybdd.screenplay.targets.Target;
import net.serenitybdd.screenplay.ui.LocatorStrategies;

public class RadioButton {
    private static final String BY_ID_OR_NAME = "css:input[id='{0}' i],input[name='{0}' i],input[data-test='{0}' i],input[class*='{0}'],[aria-label='{0}' i]";
    private static final String BY_VALUE = "css:input[type='radio'][value='{0}' i]";

    public static Target called(String name) {
        return Target.the("the '" + name + "' radio button").locatedBy(BY_ID_OR_NAME).of(name);
    }

    public static Target withValue(String value) {
        return Target.the("the '" + value + "' radio button").locatedBy(BY_VALUE).of(value);
    }

    public static Target withLabel(String labelText) {
        return Target.the("the '" + labelText + " radio button").locatedBy(LocatorStrategies.fieldWithLabel(labelText));
    }
}

