/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.targets;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.serenitybdd.core.pages.ListOfWebElementFacades;
import net.serenitybdd.core.pages.PageObject;
import net.serenitybdd.core.pages.ResolvableElement;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Question;
import net.serenitybdd.screenplay.abilities.BrowseTheWeb;
import net.serenitybdd.screenplay.targets.IFrame;
import net.serenitybdd.screenplay.targets.SearchableTarget;
import net.serenitybdd.screenplay.targets.TargetBuilder;
import net.serenitybdd.screenplay.targets.TargetResolver;
import net.serenitybdd.screenplay.ui.LocatorStrategies;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public abstract class Target
implements ResolvableElement {
    protected final String targetElementName;
    protected final Optional<IFrame> iFrame;
    protected final Optional<Duration> timeout;

    public Target(String targetElementName, Optional<IFrame> iFrame) {
        this.targetElementName = targetElementName;
        this.iFrame = iFrame;
        this.timeout = Optional.empty();
    }

    public Target(String targetElementName, Optional<IFrame> iFrame, Optional<Duration> timeout) {
        this.targetElementName = targetElementName;
        this.iFrame = iFrame;
        this.timeout = timeout;
    }

    public String toString() {
        return this.targetElementName;
    }

    public static TargetBuilder the(String targetElementName) {
        return new TargetBuilder(targetElementName);
    }

    protected PageObject currentPageVisibleTo(Actor actor) {
        return TargetResolver.create(BrowseTheWeb.as(actor).getDriver(), this);
    }

    public WebElementFacade resolveFor(Actor actor) {
        return this.resolveFor(this.currentPageVisibleTo(actor));
    }

    public ListOfWebElementFacades resolveAllFor(Actor actor) {
        return new ListOfWebElementFacades((Collection)this.resolveAllFor(this.currentPageVisibleTo(actor)));
    }

    public abstract WebElementFacade resolveFor(PageObject var1);

    public abstract ListOfWebElementFacades resolveAllFor(PageObject var1);

    public abstract SearchableTarget called(String var1);

    public abstract SearchableTarget of(String ... var1);

    public abstract String getCssOrXPathSelector();

    public Optional<IFrame> getIFrame() {
        return this.iFrame;
    }

    public String getName() {
        return this.targetElementName;
    }

    public abstract Target waitingForNoMoreThan(Duration var1);

    public SearchableTarget inside(String locator) {
        return this.inside(Target.the("Containing element").locatedBy(locator));
    }

    public SearchableTarget inside(Target container) {
        return Target.the(this.getName()).locatedBy(LocatorStrategies.findNestedElements(container, this));
    }

    public abstract List<By> selectors(WebDriver var1);

    public boolean isVisibleFor(Actor actor) {
        ListOfWebElementFacades matchingElements = this.resolveAllFor(actor);
        return !matchingElements.isEmpty() && ((WebElementFacade)matchingElements.get(0)).isCurrentlyVisible();
    }

    public <T> Question<T> mapFirst(Function<WebElementFacade, T> transformation) {
        return actor -> transformation.apply(this.resolveFor(actor));
    }

    public <T> Question<Collection<T>> mapAll(Function<WebElementFacade, T> transformation) {
        return actor -> this.resolveAllFor(actor).stream().map(transformation).collect(Collectors.toList());
    }
}

