/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ui;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.serenitybdd.core.pages.ResolvableElement;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.core.pages.WebElementFacadeImpl;
import net.serenitybdd.core.selectors.Selectors;
import net.serenitybdd.screenplay.targets.Target;
import net.serenitybdd.screenplay.ui.CSSAttributeValue;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class LocatorStrategies {
    public static Function<SearchContext, List<WebElementFacade>> fieldWithLabel(String labelText) {
        return searchContext -> {
            List matchingLabelsWithForAttribute = searchContext.findElements(By.xpath((String)LocatorStrategies.labelsWithText(labelText)));
            if (matchingLabelsWithForAttribute.isEmpty()) {
                return new ArrayList();
            }
            String fieldId = ((WebElement)matchingLabelsWithForAttribute.get(0)).getAttribute("for");
            if (fieldId == null || fieldId.isEmpty()) {
                return WebElementFacadeImpl.fromWebElements((List)matchingLabelsWithForAttribute);
            }
            return WebElementFacadeImpl.fromWebElements((List)searchContext.findElements(By.id((String)fieldId)));
        };
    }

    public static Function<SearchContext, List<WebElementFacade>> findNestedElements(Target container, Target nestedElement) {
        return searchContext -> container.resolveAllFor((SearchContext)searchContext).stream().flatMap(webElementFacade -> webElementFacade.withTimeoutOf(Duration.ZERO).findNestedElementsMatching((ResolvableElement)nestedElement).stream()).collect(Collectors.toList());
    }

    public static Function<SearchContext, List<WebElementFacade>> containingTextAndMatchingCSS(String cssOrXPathLocator, String expectedText) {
        return searchContext -> WebElementFacadeImpl.fromWebElements(searchContext.findElements(Selectors.xpathOrCssSelector((String)cssOrXPathLocator)).stream().filter(element -> element.getAttribute("textContent").contains(expectedText)).collect(Collectors.toList()));
    }

    public static Function<SearchContext, List<WebElementFacade>> containingTextAndMatchingCSS(List<String> cssOrXPathLocators, String expectedText) {
        return searchContext -> {
            ArrayList matchingElements = new ArrayList();
            for (String cssOrXPathLocator : cssOrXPathLocators) {
                matchingElements.addAll(WebElementFacadeImpl.fromWebElements(searchContext.findElements(Selectors.xpathOrCssSelector((String)cssOrXPathLocator)).stream().filter(element -> element.getAttribute("textContent").contains(expectedText)).collect(Collectors.toList())));
            }
            return WebElementFacadeImpl.fromWebElements(matchingElements);
        };
    }

    public static Function<SearchContext, List<WebElementFacade>> containingTextAndBy(By byLocator, String expectedText) {
        return searchContext -> WebElementFacadeImpl.fromWebElements(searchContext.findElements(byLocator).stream().filter(element -> LocatorStrategies.containsText(element, expectedText)).collect(Collectors.toList()));
    }

    private static boolean containsText(WebElement element, String expectedText) {
        return element.getText().contains(expectedText);
    }

    private static String labelsWithText(String labelText) {
        return ".//label[normalize-space(.)='" + CSSAttributeValue.withEscapedQuotes(labelText) + "']";
    }
}

