/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.actions;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import net.serenitybdd.screenplay.Tasks;
import net.serenitybdd.screenplay.actions.UploadToField;
import net.serenitybdd.screenplay.actions.UploadToTarget;
import net.serenitybdd.screenplay.actions.UploadToWebElement;
import net.serenitybdd.screenplay.targets.Target;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.WebElement;

public class Upload {
    public static UploadBuilder theFile(Path fileToUpload) {
        return new UploadBuilder(fileToUpload);
    }

    public static UploadBuilder theClasspathResource(String resourcePath) throws URISyntaxException {
        URL systemResource = Optional.ofNullable(ClassLoader.getSystemResource(resourcePath)).orElseThrow(() -> new InvalidArgumentException("File not found on classpath: " + resourcePath));
        Path fileToUpload = Paths.get(systemResource.toURI());
        return new UploadBuilder(fileToUpload);
    }

    public static class UploadBuilder {
        private final Path fileToUpload;

        public UploadBuilder(Path fileToUpload) {
            this.fileToUpload = fileToUpload;
        }

        public UploadToField to(Target uploadField) {
            return (UploadToField)Tasks.instrumented(UploadToTarget.class, (Object[])new Object[]{this.fileToUpload, uploadField});
        }

        public UploadToField to(WebElement uploadField) {
            return (UploadToField)Tasks.instrumented(UploadToWebElement.class, (Object[])new Object[]{this.fileToUpload, uploadField});
        }
    }
}

