/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.actions;

import net.serenitybdd.core.steps.Instrumented;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Interaction;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.Question;
import net.serenitybdd.screenplay.abilities.BrowseTheWeb;
import net.thucydides.core.annotations.Step;

public class Evaluate
implements Interaction {
    private final String expression;
    private Object[] parameters;
    private Object lastResult;

    public Evaluate(String expression) {
        this.expression = expression;
    }

    public Evaluate withParameters(Object ... parameters) {
        this.parameters = parameters;
        return this;
    }

    @Step(value="Execute JavaScript #expression")
    public <T extends Actor> void performAs(T actor) {
        this.lastResult = BrowseTheWeb.as(actor).evaluateJavascript(this.expression, this.parameters);
        if (this.lastResult != null) {
            actor.remember("LAST_SCRIPT_EXECUTION_RESULT", this.lastResult);
        } else {
            actor.forget("LAST_SCRIPT_EXECUTION_RESULT");
        }
    }

    public static Evaluate javascript(String expression, Object ... parameters) {
        Evaluate evaluate = (Evaluate)Instrumented.instanceOf(Evaluate.class).withProperties(new Object[]{expression});
        return evaluate.withParameters(parameters);
    }

    public Question<Object> result() {
        return new JavascriptAnswer(this);
    }

    public static class JavascriptAnswer
    implements Question<Object> {
        private final Evaluate expression;

        public JavascriptAnswer(Evaluate expression) {
            this.expression = expression;
        }

        public Object answeredBy(Actor actor) {
            actor.attemptsTo(new Performable[]{this.expression});
            return this.expression.lastResult;
        }
    }
}

