/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.actions;

import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.Tasks;
import net.serenitybdd.screenplay.actions.AlertAction;
import net.serenitybdd.screenplay.actions.DriverTask;
import net.serenitybdd.screenplay.actions.SwitchToNewWindow;
import net.serenitybdd.screenplay.actions.SwitchToWindowTitle;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WindowType;

public class Switch {
    public static Performable toFrame(Integer frameId) {
        return new DriverTask(driver -> driver.switchTo().frame(frameId.intValue()));
    }

    public static Performable toNewWindow(WindowType windowType) {
        return new DriverTask(driver -> driver.switchTo().newWindow(windowType));
    }

    public static Performable toFrame(String frameName) {
        return new DriverTask(driver -> driver.switchTo().frame(frameName));
    }

    public static Performable toFrame(WebElement webElement) {
        return new DriverTask(driver -> driver.switchTo().frame(webElement));
    }

    public static Performable toParentFrame() {
        return new DriverTask(driver -> driver.switchTo().parentFrame());
    }

    public static Performable toWindow(String nameOrHandle) {
        return new DriverTask(driver -> driver.switchTo().window(nameOrHandle));
    }

    public static Performable toNewWindow() {
        return Tasks.instrumented(SwitchToNewWindow.class, (Object[])new Object[0]);
    }

    public static Performable toWindowTitled(String title) {
        return Tasks.instrumented(SwitchToWindowTitle.class, (Object[])new Object[]{title});
    }

    public static Performable toTheOtherWindow() {
        return new DriverTask(driver -> {
            String currentWindow = driver.getWindowHandle();
            driver.getWindowHandles().stream().filter(handle -> !handle.equals(currentWindow)).findFirst().ifPresent(otherWindowHandle -> driver.switchTo().window(otherWindowHandle));
        });
    }

    public static AlertAction toAlert() {
        return new AlertAction();
    }

    public static Performable toDefaultContext() {
        return new DriverTask(driver -> driver.switchTo().defaultContent());
    }

    public static Performable toActiveElement() {
        return new DriverTask(driver -> driver.switchTo().activeElement());
    }
}

