/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ui;

import net.serenitybdd.screenplay.targets.SearchableTarget;
import net.serenitybdd.screenplay.targets.Target;
import net.serenitybdd.screenplay.ui.CSSAttributeValue;
import net.serenitybdd.screenplay.ui.LocatorStrategies;
import net.serenitybdd.screenplay.ui.TargetFactory;
import org.openqa.selenium.By;

public class InputField {
    private static final String BY_ID_OR_NAME = "css:input[id='{0}' i],input[name='{0}' i],input[data-test='{0}' i],textarea[id='{0}' i],textarea[name='{0}' i],textarea[data-test='{0}' i],[aria-label='{0}' i]";
    private static final String ARIA_LABEL = "input[aria-label='{0}' i],textarea[aria-label='{0}' i]";

    public static SearchableTarget withNameOrId(String name) {
        return Target.the("the '" + name + "' input field").locatedBy(BY_ID_OR_NAME).of(name);
    }

    public static SearchableTarget withPlaceholder(String placeholderName) {
        String placeholderAttribute = CSSAttributeValue.withEscapedQuotes(placeholderName);
        return Target.the("'" + placeholderName + "' field").locatedBy("css:[placeholder='{0}']").of(placeholderAttribute);
    }

    public static Target withLabel(String labelText) {
        return Target.the(labelText + " input field").locatedBy(LocatorStrategies.fieldWithLabel(labelText));
    }

    public static SearchableTarget withAriaLabel(String name) {
        return Target.the("'" + name + "' input field").locatedByFirstMatching("css:input[aria-label='{0}' i],textarea[aria-label='{0}' i]").of(name);
    }

    public static SearchableTarget withCSSClass(String className) {
        return TargetFactory.forElementOfType("input field").withCSSClass(className);
    }

    public static SearchableTarget locatedBy(String selector) {
        return TargetFactory.forElementOfType("input field").locatedByXPathOrCss(selector);
    }

    public static SearchableTarget located(By selector) {
        return TargetFactory.forElementOfType("input field").locatedBy(selector);
    }
}

