/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.actions;

import net.serenitybdd.annotations.Step;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.actions.Click;
import net.serenitybdd.screenplay.actions.ClickOnClickable;
import net.serenitybdd.screenplay.questions.SelectedStatus;
import net.serenitybdd.screenplay.targets.Target;

public class CheckCheckboxOfTarget
extends ClickOnClickable {
    private final Target target;
    private final boolean expectedToBeChecked;

    public CheckCheckboxOfTarget(Target target, boolean expectedToBeChecked) {
        this.target = target;
        this.expectedToBeChecked = expectedToBeChecked;
    }

    @Step(value="{0} sets value of checkbox #target to #expectedToBeChecked")
    public <T extends Actor> void performAs(T actor) {
        boolean isSelected = (Boolean)actor.asksFor(SelectedStatus.of(this.target));
        if (isSelected != this.expectedToBeChecked) {
            actor.attemptsTo(new Performable[]{Click.on(this.target)});
        }
    }
}

