/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import net.serenitybdd.screenplay.Complaint;
import net.serenitybdd.screenplay.Consequence;
import net.thucydides.core.steps.StepEventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConsequence<T>
implements Consequence<T> {
    private Class<? extends Error> complaintType;
    private String complaintDetails;
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    protected Error errorFrom(Throwable actualError) {
        if (actualError instanceof Error) {
            return (Error)actualError;
        }
        return new Error(actualError);
    }

    protected void throwComplaintTypeErrorIfSpecified(Error actualError) {
        if (this.complaintType != null) {
            this.LOGGER.error("Could not resolve question", (Throwable)actualError);
            throw Complaint.from(this.complaintType, this.complaintDetails, actualError);
        }
    }

    protected boolean thisStepShouldBeIgnored() {
        return StepEventBus.getEventBus().currentTestIsSuspended() || StepEventBus.getEventBus().aStepInTheCurrentTestHasFailed();
    }

    @Override
    public BaseConsequence<T> orComplainWith(Class<? extends Error> complaintType) {
        return this.orComplainWith((Class)complaintType, (String)null);
    }

    @Override
    public BaseConsequence<T> orComplainWith(Class<? extends Error> complaintType, String complaintDetails) {
        this.complaintType = complaintType;
        this.complaintDetails = complaintDetails;
        return this;
    }
}

