/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.Question;

public class ConditionalPerformable
implements Performable {
    private final Question<Boolean> shouldNotPerform;
    private final Performable task;

    public ConditionalPerformable(Question<Boolean> shouldNotPerform, Performable task) {
        this.shouldNotPerform = shouldNotPerform;
        this.task = task;
    }

    @Override
    public <T extends Actor> void performAs(T actor) {
        if (this.shouldNotPerform.answeredBy(actor).booleanValue()) {
            return;
        }
        this.task.performAs(actor);
    }
}

