/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import net.serenitybdd.core.time.Stopwatch;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Consequence;
import net.serenitybdd.screenplay.EventualConsequenceBuilder;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.webdriver.Configuration;

public class EventualConsequence<T>
implements Consequence<T> {
    public static final int A_SHORT_PERIOD_BETWEEN_TRIES = 100;
    private final Consequence<T> consequenceThatMightTakeSomeTime;
    private final long timeout;
    private AssertionError caughtAssertionError = null;
    private RuntimeException caughtRuntimeException = null;

    public EventualConsequence(Consequence<T> consequenceThatMightTakeSomeTime, long timeout) {
        this.consequenceThatMightTakeSomeTime = consequenceThatMightTakeSomeTime;
        this.timeout = timeout;
    }

    public EventualConsequence(Consequence<T> consequenceThatMightTakeSomeTime) {
        this(consequenceThatMightTakeSomeTime, ((Configuration)Injectors.getInjector().getInstance(Configuration.class)).getElementTimeout() * 1000);
    }

    public static <T> EventualConsequence<T> eventually(Consequence<T> consequenceThatMightTakeSomeTime) {
        return new EventualConsequence<T>(consequenceThatMightTakeSomeTime);
    }

    public EventualConsequenceBuilder<T> waitingForNoLongerThan(long amount) {
        return new EventualConsequenceBuilder(this.consequenceThatMightTakeSomeTime, amount);
    }

    @Override
    public void evaluateFor(Actor actor) {
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        do {
            try {
                this.consequenceThatMightTakeSomeTime.evaluateFor(actor);
                return;
            }
            catch (AssertionError assertionError) {
                this.caughtAssertionError = assertionError;
            }
            catch (RuntimeException runtimeException) {
                this.caughtRuntimeException = runtimeException;
            }
            this.pauseBeforeNextAttempt();
        } while (stopwatch.lapTime() < this.timeout);
        this.throwAnyCaughtErrors();
    }

    private void pauseBeforeNextAttempt() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void throwAnyCaughtErrors() {
        if (this.caughtAssertionError != null) {
            throw this.caughtAssertionError;
        }
        if (this.caughtRuntimeException != null) {
            throw this.caughtRuntimeException;
        }
    }

    public String toString() {
        return this.consequenceThatMightTakeSomeTime.toString();
    }

    @Override
    public Consequence<T> orComplainWith(Class<? extends Error> complaintType) {
        return new EventualConsequence<T>(this.consequenceThatMightTakeSomeTime.orComplainWith(complaintType));
    }

    @Override
    public Consequence<T> orComplainWith(Class<? extends Error> complaintType, String complaintDetails) {
        return new EventualConsequence<T>(this.consequenceThatMightTakeSomeTime.orComplainWith(complaintType, complaintDetails));
    }
}

