/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import net.serenitybdd.markers.CanBeSilent;
import net.serenitybdd.screenplay.Consequence;
import net.serenitybdd.screenplay.EventBusInterface;
import net.serenitybdd.screenplay.SilentTasks;
import net.serenitybdd.screenplay.formatting.FormattedTitle;

class ConsequenceCheckReporter {
    private final EventBusInterface eventBusInterface;
    private final Consequence consequence;

    ConsequenceCheckReporter(EventBusInterface eventBusInterface, Consequence consequence) {
        this.eventBusInterface = eventBusInterface;
        this.consequence = consequence;
    }

    public void startQuestion() {
        if (this.shouldReportConsequence()) {
            this.eventBusInterface.startQuestion(FormattedTitle.ofConsequence(this.consequence));
        }
    }

    private boolean shouldReportConsequence() {
        if (this.consequence instanceof CanBeSilent && ((CanBeSilent)this.consequence).isSilent()) {
            return false;
        }
        return !SilentTasks.isNestedInSilentTask();
    }

    public void reportStepIgnored() {
        if (this.shouldReportConsequence()) {
            this.eventBusInterface.reportStepIgnored();
        }
    }

    public void reportStepFinished() {
        if (this.shouldReportConsequence()) {
            this.eventBusInterface.reportStepFinished();
        }
    }
}

