/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.serenitybdd.core.PendingStepException;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.SkipNested;
import net.serenitybdd.core.eventbus.Broadcaster;
import net.serenitybdd.core.parallel.Agent;
import net.serenitybdd.markers.IsHidden;
import net.serenitybdd.screenplay.Ability;
import net.serenitybdd.screenplay.Consequence;
import net.serenitybdd.screenplay.ConsequenceCheckReporter;
import net.serenitybdd.screenplay.ConsequenceListener;
import net.serenitybdd.screenplay.ErrorTally;
import net.serenitybdd.screenplay.EventBusInterface;
import net.serenitybdd.screenplay.HasTeardown;
import net.serenitybdd.screenplay.InstrumentedTask;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.PerformedTaskTally;
import net.serenitybdd.screenplay.PerformsTasks;
import net.serenitybdd.screenplay.Question;
import net.serenitybdd.screenplay.RefersToActor;
import net.serenitybdd.screenplay.SilentTasks;
import net.serenitybdd.screenplay.events.ActorBeginsConsequenceCheckEvent;
import net.serenitybdd.screenplay.events.ActorBeginsPerformanceEvent;
import net.serenitybdd.screenplay.events.ActorEndsConsequenceCheckEvent;
import net.serenitybdd.screenplay.events.ActorEndsPerformanceEvent;
import net.serenitybdd.screenplay.events.ActorPerforms;
import net.serenitybdd.screenplay.exceptions.IgnoreStepException;
import net.serenitybdd.screenplay.facts.Fact;
import net.serenitybdd.screenplay.facts.FactLifecycleListener;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.Pending;
import net.thucydides.core.annotations.Step;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.util.EnvironmentVariables;

public class Actor
implements PerformsTasks,
SkipNested,
Agent {
    private String id;
    private String name;
    private final PerformedTaskTally taskTally = new PerformedTaskTally();
    private EventBusInterface eventBusInterface = new EventBusInterface();
    private ConsequenceListener consequenceListener = new ConsequenceListener(this.eventBusInterface);
    private String description;
    private Map<String, Object> notepad = new HashMap<String, Object>();
    private Map<Class, Ability> abilities = new HashMap<Class, Ability>();
    private String preferredPronoun;
    private List<FactLifecycleListener> factListeners = new ArrayList<FactLifecycleListener>();

    public Actor(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getNameOrPronoun();
    }

    public static Actor named(String name) {
        EventBusInterface.castActor(name);
        return new Actor(name);
    }

    public Actor describedAs(String description) {
        this.description = description;
        this.assignDescriptionToActor(description);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getNameOrPronoun() {
        return this.preferredPronoun != null ? this.preferredPronoun : this.name;
    }

    public <T extends Ability> Actor can(T doSomething) {
        if (doSomething instanceof RefersToActor) {
            ((RefersToActor)((Object)doSomething)).asActor(this);
        }
        this.abilities.put(doSomething.getClass(), doSomething);
        this.eventBusInterface.assignAbilityToActor(this, doSomething.toString());
        return this;
    }

    public <T extends Ability> Actor whoCan(T doSomething) {
        return this.can(doSomething);
    }

    public <T extends Ability> T abilityTo(Class<? extends T> doSomething) {
        Ability ability = this.abilities.get(doSomething);
        if (ability == null) {
            ability = (Ability)this.getAbilityThatExtends(doSomething);
        }
        return (T)ability;
    }

    public <C> C getAbilityThatExtends(Class<C> extendedClass) {
        for (Map.Entry<Class, Ability> entry : this.abilities.entrySet()) {
            if (!extendedClass.isAssignableFrom(entry.getKey())) continue;
            return (C)entry.getValue();
        }
        return null;
    }

    public List<HasTeardown> getTeardowns() {
        ArrayList<HasTeardown> teardowns = new ArrayList<HasTeardown>();
        for (Ability a : this.abilities.values()) {
            if (!(a instanceof HasTeardown)) continue;
            teardowns.add((HasTeardown)((Object)a));
        }
        return teardowns;
    }

    public <T extends Ability> T usingAbilityTo(Class<? extends T> doSomething) {
        return this.abilityTo(doSomething);
    }

    public final void entersTheScene() {
    }

    public final void has(Performable ... todos) {
        this.attemptsTo(todos);
    }

    public final void has(Fact ... facts) {
        Arrays.stream(facts).forEach(fact -> {
            fact.setup(this);
            this.eventBusInterface.assignFactToActor(this, fact.toString());
            FactLifecycleListener listener = new FactLifecycleListener(this, (Fact)fact);
            this.factListeners.add(listener);
            StepEventBus.getEventBus().registerListener((StepListener)listener);
        });
    }

    public final void wasAbleTo(Performable ... todos) {
        this.attemptsTo(todos);
    }

    public final void attemptsTo(Performable ... tasks) {
        this.beginPerformance();
        for (Performable task : tasks) {
            if (SilentTasks.isNestedInSilentTask()) {
                this.performSilently(task);
                continue;
            }
            if (SilentTasks.isSilent(task)) {
                this.performSilently(task);
                continue;
            }
            if (this.isHidden(task) || this.shouldNotReport(task)) {
                this.performWithoutReporting(task);
                continue;
            }
            this.perform(InstrumentedTask.of(task));
        }
        this.endPerformance();
    }

    private boolean isHidden(Performable task) {
        return task instanceof IsHidden;
    }

    private boolean shouldNotReport(Performable task) {
        if (this.manualTaskInstrumentation() && this.noStepAnnotationIsPresentIn(task)) {
            return true;
        }
        return !InstrumentedTask.isInstrumented(task) && !InstrumentedTask.shouldInstrument(task);
    }

    private boolean noStepAnnotationIsPresentIn(Performable task) {
        try {
            return task.getClass().getMethod("performAs", new Class[0]).getAnnotation(Step.class) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    @Override
    public <ANSWER> ANSWER asksFor(Question<ANSWER> question) {
        this.beginPerformance();
        ANSWER answer = question.answeredBy(this);
        this.endPerformance();
        return answer;
    }

    private <T extends Performable> void performSilently(T todo) {
        this.perform(todo);
    }

    private <T extends Performable> void performWithoutReporting(T todo) {
        this.perform(todo);
    }

    private <T extends Performable> void performConditionally(T todo) {
        this.perform(todo);
    }

    private <T extends Performable> void perform(T todo) {
        if (this.isPending(todo)) {
            StepEventBus.getEventBus().stepPending();
        }
        try {
            this.notifyPerformanceOf(todo);
            this.taskTally.newTask();
            this.performTask(todo);
            if (this.anOutOfStepErrorOccurred()) {
                this.eventBusInterface.mergePreviousStep();
            }
        }
        catch (Throwable exception) {
            if (!this.pendingOrIgnore(exception)) {
                this.eventBusInterface.reportStepFailureFor(todo, exception);
            }
            if (Serenity.shouldThrowErrorsImmediately() || this.isAnAssumptionFailure(exception)) {
                throw exception;
            }
        }
        finally {
            this.eventBusInterface.updateOverallResult();
        }
    }

    private <T extends Performable> void performTask(T todo) {
        if (!StepEventBus.getEventBus().currentTestIsSuspended()) {
            todo.performAs((Actor)this);
        }
    }

    private <T extends Performable> void notifyPerformanceOf(T todo) {
        Broadcaster.getEventBus().post((Object)new ActorPerforms(todo, this.getName()));
    }

    private <T extends Performable> boolean isPending(T todo) {
        Method performAs = this.getPerformAsForClass(todo.getClass().getSuperclass()).orElse(this.getPerformAsForClass(todo.getClass()).orElse(null));
        return performAs != null && performAs.getAnnotation(Pending.class) != null;
    }

    private Optional<Method> getPerformAsForClass(Class taskClass) {
        try {
            return Optional.of(taskClass.getMethod("performAs", Actor.class));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    private boolean pendingOrIgnore(Throwable exception) {
        return exception instanceof IgnoreStepException || exception instanceof PendingStepException;
    }

    private boolean isAnAssumptionFailure(Throwable e) {
        return e.getClass().getSimpleName().contains("Assumption");
    }

    public final void can(Consequence<?> ... consequences) {
        this.should(consequences);
    }

    public final void should(String groupStepName, Consequence<?> ... consequences) {
        try {
            String groupTitle = this.injectActorInto(groupStepName);
            StepEventBus.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)groupTitle));
            this.should(consequences);
        }
        catch (Throwable error) {
            throw error;
        }
        finally {
            StepEventBus.getEventBus().stepFinished();
        }
    }

    private String injectActorInto(String groupStepName) {
        return groupStepName.replaceAll("\\{0\\}", this.toString());
    }

    public final void should(List<Consequence<?>> consequences) {
        this.should(consequences.toArray(new Consequence[0]));
    }

    public final void should(Consequence<?> ... consequences) {
        ErrorTally errorTally = new ErrorTally(this.eventBusInterface);
        this.startConsequenceCheck();
        for (Consequence<?> consequence : consequences) {
            this.check(consequence, errorTally);
        }
        this.endConsequenceCheck();
        errorTally.reportAnyErrors();
    }

    private boolean anOutOfStepErrorOccurred() {
        if (this.eventBusInterface.aStepHasFailedInTheCurrentExample()) {
            return this.eventBusInterface.getRunningStepCount() > this.taskTally.getPerformedTaskCount();
        }
        return false;
    }

    private <T> void check(Consequence<T> consequence, ErrorTally errorTally) {
        ConsequenceCheckReporter reporter = new ConsequenceCheckReporter(this.eventBusInterface, consequence);
        try {
            reporter.startQuestion(this);
            if (this.eventBusInterface.shouldIgnoreConsequences()) {
                reporter.reportStepIgnored();
            } else {
                consequence.evaluateFor(this);
                reporter.reportStepFinished();
            }
        }
        catch (IgnoreStepException e) {
            reporter.reportStepIgnored();
        }
        catch (Throwable e) {
            errorTally.recordError(consequence, e);
        }
    }

    public <ANSWER> void remember(String key, Question<ANSWER> question) {
        this.beginPerformance();
        ANSWER answer = this.asksFor(question);
        this.notepad.put(key, answer);
        this.endPerformance();
    }

    public void remember(String key, Object value) {
        this.notepad.put(key, value);
    }

    public <T> T recall(String key) {
        return (T)this.notepad.get(key);
    }

    public Map<String, Object> recallAll() {
        return new HashMap<String, Object>(this.notepad);
    }

    public <T> T forget(String key) {
        return (T)this.notepad.remove(key);
    }

    public <T> T sawAsThe(String key) {
        return this.recall(key);
    }

    public <T> T gaveAsThe(String key) {
        return this.recall(key);
    }

    private void beginPerformance() {
        Serenity.setSessionVariable((Object)"$AGENT").to((Object)this);
        Broadcaster.getEventBus().post((Object)new ActorBeginsPerformanceEvent(this.name));
    }

    private void endPerformance() {
        Broadcaster.getEventBus().post((Object)new ActorEndsPerformanceEvent(this.name));
    }

    private void startConsequenceCheck() {
        this.beginPerformance();
        this.consequenceListener.beginConsequenceCheck();
        Broadcaster.getEventBus().post((Object)new ActorBeginsConsequenceCheckEvent(this.name));
    }

    private void endConsequenceCheck() {
        this.consequenceListener.endConsequenceCheck();
        Broadcaster.getEventBus().post((Object)new ActorEndsConsequenceCheckEvent(this.name));
        this.endPerformance();
    }

    public Actor usingPronoun(String pronoun) {
        this.preferredPronoun = pronoun;
        return this;
    }

    public Actor withNoPronoun() {
        this.preferredPronoun = null;
        return this;
    }

    public void assignDescriptionToActor(String description) {
        StepEventBus.getEventBus().getBaseStepListener().latestTestOutcome().ifPresent(testOutcome -> testOutcome.assignDescriptionToActor(this.getName(), description));
    }

    public void assignName(String name) {
        this.name = name;
    }

    private boolean manualTaskInstrumentation() {
        EnvironmentVariables environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
        return ThucydidesSystemProperty.MANUAL_TASK_INSTRUMENTATION.booleanFrom(environmentVariables, Boolean.valueOf(false));
    }

    public void wrapUp() {
        this.getTeardowns().forEach(HasTeardown::tearDown);
        this.factListeners.forEach(factLifecycleListener -> StepEventBus.getEventBus().dropListener((StepListener)factLifecycleListener));
    }

    public String getId() {
        return this.id;
    }
}

